/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.controller;

import com.install4j.api.actions.Action;
import com.install4j.api.actions.InstallAction;
import com.install4j.api.beans.Bean;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.events.EventType;
import com.install4j.api.events.InstallerEvent;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.groups.ActionGroup;
import com.install4j.runtime.beans.groups.ControlFlowGroup;
import com.install4j.runtime.beans.groups.Group;
import com.install4j.runtime.beans.screens.FormScreen;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.AbstractBeanConfig;
import com.install4j.runtime.installer.config.ActionBeanConfig;
import com.install4j.runtime.installer.config.GroupBeanConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ActionCallback;
import com.install4j.runtime.installer.controller.ActionCallbackCommand;
import com.install4j.runtime.installer.controller.CommandSink;
import com.install4j.runtime.installer.controller.ControllerCommand;
import com.install4j.runtime.installer.controller.FinishCommand;
import com.install4j.runtime.installer.controller.GoBackCommand;
import com.install4j.runtime.installer.controller.GoBackInHistoryToScreenCommand;
import com.install4j.runtime.installer.controller.GoForwardCommand;
import com.install4j.runtime.installer.controller.GotoScreenCommand;
import com.install4j.runtime.installer.controller.LanguageSelector;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.ServiceHandler;
import com.install4j.runtime.installer.helper.content.ContentInstaller;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import java.awt.EventQueue;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Stack;

public class Controller {
    private ScreenExecutor screenExecutor;
    private ContextImpl context;
    private List startedActions = new ArrayList();
    private List screenConfigHistory = new ArrayList();
    private Map groupConfig2Result = new HashMap();

    public Controller(ScreenExecutor screenExecutor) {
        this.context = screenExecutor.getContext();
        this.screenExecutor = screenExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        VersionSpecificHelper.init();
        InstallerUtil.registerStarted();
        InstallerVariables.setReplaceI18nVariables(true);
        InstallerUtil.setConsole(this.screenExecutor.isConsole());
        InstallerUtil.setUnattended(this.screenExecutor.isUnattended());
        InstallerUtil.loadJREDeployLibs();
        LanguageSelector.initLanguage(this.context, this.screenExecutor);
        if (!this.context.checkStart()) {
            System.exit(1);
        }
        this.context.registerScreens(true);
        if (this.getScreenConfigsFlat().size() == 0) {
            return;
        }
        ScreenBeanConfig screenBeanConfig = this.handleStartup();
        while (screenBeanConfig != null) {
            CommandSink commandSink = new CommandSink(this);
            this.execute(screenBeanConfig, commandSink);
            CommandSink commandSink2 = commandSink;
            synchronized (commandSink2) {
                while (commandSink.getCommand() == null) {
                    try {
                        commandSink.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            if ((screenBeanConfig = this.handleCommand(commandSink, screenBeanConfig)) != null) continue;
            commandSink.finished();
        }
        System.exit(0);
    }

    private ScreenBeanConfig handleStartup() {
        ScreenBeanConfig screenBeanConfig = (ScreenBeanConfig)this.getScreenConfigsFlat().get(0);
        CommandSink commandSink = new CommandSink(this);
        commandSink.returnToController(new GoForwardCommand(1, true, true, null));
        return this.handleCommand(commandSink, screenBeanConfig);
    }

    private void execute(final ScreenBeanConfig screenBeanConfig, final CommandSink commandSink) {
        this.screenConfigHistory.add(screenBeanConfig);
        ArrayList arrayList = new ArrayList();
        ScreenBeanConfig screenBeanConfig2 = this.findPreviousScreenConfig(false, arrayList);
        final boolean bl = screenBeanConfig2 != null && screenBeanConfig.getBackButtonType() != 3 && (screenBeanConfig.getBackButtonType() != 2 || !this.hasNonMultiExecActions(screenBeanConfig2.getActionConfigs()) && arrayList.size() == 0);
        Screen screen = screenBeanConfig.getOrInstantiateScreen(false);
        this.context.fireInstallerEvent(new InstallerEvent(screen, this.context, EventType.SHOW_SCREEN, true));
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Controller.this.screenExecutor.execute(screenBeanConfig, commandSink, bl);
            }
        });
    }

    private boolean hasNonMultiExecActions(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof GroupBeanConfig ? this.hasNonMultiExecActions(((GroupBeanConfig)e).getBeanConfigs()) : e instanceof ActionBeanConfig && !((ActionBeanConfig)e).isMultiExec())) continue;
            return true;
        }
        return false;
    }

    private ScreenBeanConfig handleCommand(CommandSink commandSink, ScreenBeanConfig screenBeanConfig) {
        ControllerCommand controllerCommand = commandSink.getCommand();
        ActionCallback actionCallback = null;
        try {
            if (controllerCommand instanceof GoForwardCommand && ((GoForwardCommand)controllerCommand).isExecuteActions() || controllerCommand instanceof FinishCommand) {
                actionCallback = ((ActionCallbackCommand)controllerCommand).getActionCallback();
                commandSink.allowOverride();
                if (actionCallback != null) {
                    actionCallback.actionsStarted();
                }
                try {
                    this.executeActions(screenBeanConfig.getActionConfigs(), "", false);
                    this.checkRollbackBarrier(screenBeanConfig, screenBeanConfig.getOrInstantiateScreen(false));
                }
                catch (UserCanceledException userCanceledException) {
                    this.rollback(commandSink);
                }
                controllerCommand = commandSink.getOverriddenCommand();
            }
            Logger.getInstance().info(screenBeanConfig.getOrInstantiateScreen(false), "command: " + controllerCommand);
            if (controllerCommand instanceof GoForwardCommand) {
                GoForwardCommand goForwardCommand = (GoForwardCommand)controllerCommand;
                if (goForwardCommand.isCheckCondition()) {
                    ScreenBeanConfig screenBeanConfig2 = this.findNextScreenConfig(screenBeanConfig, goForwardCommand.getNumber());
                    if (screenBeanConfig2 == null) {
                        this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.FINISHING, true));
                        commandSink.finished();
                        this.context.finish(0);
                    }
                    ScreenBeanConfig screenBeanConfig3 = screenBeanConfig2;
                    return screenBeanConfig3;
                }
                int n = this.getIndex(screenBeanConfig);
                ScreenBeanConfig screenBeanConfig4 = (ScreenBeanConfig)this.getScreenConfigsFlat().get(n + goForwardCommand.getNumber());
                return screenBeanConfig4;
            }
            if (controllerCommand instanceof GoBackCommand) {
                GoBackCommand goBackCommand = (GoBackCommand)controllerCommand;
                if (goBackCommand.isUseHistory()) {
                    this.screenConfigHistory.remove(this.screenConfigHistory.size() - 1);
                    if (goBackCommand.getNumber() == 0) {
                        ScreenBeanConfig screenBeanConfig5 = screenBeanConfig;
                        return screenBeanConfig5;
                    }
                    ScreenBeanConfig screenBeanConfig6 = null;
                    for (int i = 0; i < goBackCommand.getNumber(); ++i) {
                        screenBeanConfig6 = this.findPreviousScreenConfig(true, null);
                    }
                    if (screenBeanConfig6 == null) {
                        throw new RuntimeException("Could not go back " + goBackCommand.getNumber() + " step in history from " + screenBeanConfig.getOrInstantiateScreen(true));
                    }
                    ScreenBeanConfig screenBeanConfig7 = screenBeanConfig6;
                    return screenBeanConfig7;
                }
                int n = this.getIndex(screenBeanConfig);
                ScreenBeanConfig screenBeanConfig8 = (ScreenBeanConfig)this.getScreenConfigsFlat().get(n - goBackCommand.getNumber());
                return screenBeanConfig8;
            }
            if (controllerCommand instanceof GoBackInHistoryToScreenCommand) {
                ScreenBeanConfig screenBeanConfig9;
                Screen screen = ((GoBackInHistoryToScreenCommand)controllerCommand).getScreen();
                this.screenConfigHistory.remove(this.screenConfigHistory.size() - 1);
                if (screen == screenBeanConfig.getOrInstantiateScreen(false)) {
                    ScreenBeanConfig screenBeanConfig10 = screenBeanConfig;
                    return screenBeanConfig10;
                }
                do {
                    if ((screenBeanConfig9 = this.findPreviousScreenConfig(true, null)) != null) continue;
                    throw new RuntimeException("Could not go back in history to screen " + screen.toString());
                } while (screenBeanConfig9.getOrInstantiateScreen(false) != screen);
                ScreenBeanConfig screenBeanConfig11 = screenBeanConfig9;
                return screenBeanConfig11;
            }
            if (controllerCommand instanceof FinishCommand) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.FINISHING, true));
                commandSink.finished();
                this.context.finish(0);
                ScreenBeanConfig screenBeanConfig12 = null;
                return screenBeanConfig12;
            }
            if (controllerCommand == ControllerCommand.CANCEL) {
                this.rollback(commandSink);
                ScreenBeanConfig screenBeanConfig13 = null;
                return screenBeanConfig13;
            }
            if (controllerCommand instanceof GotoScreenCommand) {
                int n = this.getIndex(((GotoScreenCommand)controllerCommand).getScreen());
                ScreenBeanConfig screenBeanConfig14 = (ScreenBeanConfig)this.getScreenConfigsFlat().get(n);
                return screenBeanConfig14;
            }
            throw new RuntimeException("Unknown command " + controllerCommand.toString());
        }
        finally {
            if (actionCallback != null) {
                actionCallback.actionsFinished();
            }
        }
    }

    public void rollback(CommandSink commandSink) {
        this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.CANCELLING, true));
        FileInstaller fileInstaller = FileInstaller.getInstance();
        if (this.startedActions.size() > 0 || fileInstaller.hasRollbackFiles()) {
            ServiceHandler.resetStopState();
            this.context.setRollback();
            this.context.getProgressInterface().setDetailMessage("");
            this.context.getProgressInterface().setStatusMessage(Messages.getMessages().getString("StatusRollback"));
            for (int i = this.startedActions.size() - 1; i >= 0; --i) {
                Action action = (Action)this.startedActions.get(i);
                this.context.rollbackAction(action);
            }
            if (fileInstaller.hasRollbackFiles()) {
                ServiceHandler.stopServices(this.context, true);
                fileInstaller.rollback(this.context.getProgressInterface());
                ContentInstaller.getInstance().rollback();
            }
        }
        if (fileInstaller.hasUnrollbackedFiles()) {
            this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.CANCELED, true));
            commandSink.finished();
            this.context.finish(1);
        }
        this.context.fireInstallerEvent(new InstallerEvent(this.context, this.context, EventType.CANCELED, true));
        commandSink.finished();
        this.context.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeActions(List list, String string, boolean bl) throws UserCanceledException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Bean bean;
            AbstractBeanConfig abstractBeanConfig;
            Object e = iterator.next();
            if (e instanceof ActionBeanConfig) {
                abstractBeanConfig = (ActionBeanConfig)e;
                bean = ((ActionBeanConfig)abstractBeanConfig).getOrInstantiateAction(false);
                if (this.context.isCancelling()) {
                    throw new UserCanceledException();
                }
                if (!((ActionBeanConfig)abstractBeanConfig).isMultiExec() && ((ActionBeanConfig)abstractBeanConfig).isExecuted() || !this.context.runBooleanScript(abstractBeanConfig.getConditionClassName(), bean)) continue;
                if (!(((ActionBeanConfig)abstractBeanConfig).isExecuted() || bean instanceof InstallAction && this.isRollbackSupported((Action)bean))) {
                    this.startedActions.add(bean);
                }
                ((ActionBeanConfig)abstractBeanConfig).setExecuted(true);
                try {
                    if (this.context.performAction((Action)bean)) continue;
                    this.handleFailure((ActionBeanConfig)abstractBeanConfig, bean.getClass(), string);
                    if (!bl) continue;
                    boolean bl2 = false;
                    return bl2;
                }
                catch (InstallerVariables.UndefinedVariableException undefinedVariableException) {
                    Logger.getInstance().error(bean, "undefined variable: " + undefinedVariableException.getMessage());
                    this.handleFailure((ActionBeanConfig)abstractBeanConfig, bean.getClass(), string);
                    if (!bl) continue;
                    boolean bl3 = false;
                    return bl3;
                }
                finally {
                    this.checkRollbackBarrier(abstractBeanConfig, bean);
                    continue;
                }
            }
            abstractBeanConfig = (GroupBeanConfig)e;
            if (!this.checkGroupCondition((GroupBeanConfig)abstractBeanConfig)) continue;
            bean = (ActionGroup)((GroupBeanConfig)abstractBeanConfig).getOrInstantiateGroup(false);
            do {
                String string2;
                if ((string2 = ((ActionGroup)bean).getDefaultErrorMessage().trim()).length() == 0) {
                    string2 = string;
                }
                if (this.executeActions(((GroupBeanConfig)abstractBeanConfig).getBeanConfigs(), string2, ((ActionGroup)bean).isOnErrorBreakGroup()) || !bl) continue;
                return false;
            } while (this.isGroupLoop((GroupBeanConfig)abstractBeanConfig));
        }
        return true;
    }

    private boolean isRollbackSupported(Action action) {
        try {
            return !((InstallAction)action).isRollbackSupported();
        }
        catch (AbstractMethodError abstractMethodError) {
            return false;
        }
    }

    private void handleFailure(ActionBeanConfig actionBeanConfig, Class clazz, String string) throws UserCanceledException {
        boolean bl;
        this.context.setErrorOccured(true);
        String string2 = actionBeanConfig.getErrorMessage().trim();
        if (string2.length() == 0) {
            string2 = string.trim();
        }
        boolean bl2 = bl = actionBeanConfig.getFailureStrategy() == 2;
        if (bl || actionBeanConfig.getFailureStrategy() == 1) {
            if (string2.length() > 0) {
                GUIHelper.showMessage(null, string2, bl ? 0 : 2);
            }
            if (bl) {
                this.quitAndKeepLogFile();
            }
        } else {
            ResourceBundle resourceBundle = Messages.getMessages();
            if (string2.length() == 0) {
                string2 = MessageFormat.format(resourceBundle.getString("ErrorFunctionFailedNoCode"), clazz.getName()) + "\n";
            }
            if (GUIHelper.showOptionDialog(null, string2, new String[]{resourceBundle.getString("ButtonOK"), resourceBundle.getString("ButtonCancel")}, 0) == 1) {
                this.quitAndKeepLogFile();
            }
        }
    }

    private void quitAndKeepLogFile() throws UserCanceledException {
        System.setProperty("install4j.keepLog", "true");
        throw new UserCanceledException();
    }

    private void checkRollbackBarrier(AbstractBeanConfig abstractBeanConfig, Bean bean) {
        if (abstractBeanConfig.isRollbackBarrier()) {
            this.startedActions.clear();
            FileInstaller.getInstance().setRollbackBarrier();
            Logger.getInstance().info(bean, "Rollback barrier reached");
        }
    }

    private ScreenBeanConfig findNextScreenConfig(ScreenBeanConfig screenBeanConfig, int n) {
        boolean bl;
        List list = this.getScreenConfigsFlat();
        int n2 = list.size();
        int n3 = -1;
        if (screenBeanConfig != null) {
            n3 = this.getIndex(screenBeanConfig);
        }
        n3 += n;
        boolean bl2 = bl = n == 1;
        while (n3 < n2) {
            Screen screen;
            if (bl) {
                n3 = this.getScreenIndexWithLoop(n3, this.groupConfig2Result);
            }
            ScreenBeanConfig screenBeanConfig2 = (ScreenBeanConfig)list.get(n3);
            ArrayList arrayList = new ArrayList();
            Controller.addCurrentScreenGroups(screenBeanConfig2, this.getScreenConfigs(), arrayList);
            Controller.retainInMap(this.groupConfig2Result, new HashSet(arrayList));
            Boolean bl3 = Boolean.TRUE;
            for (int i = arrayList.size() - 1; i >= 0 && bl3.booleanValue(); --i) {
                GroupBeanConfig groupBeanConfig = (GroupBeanConfig)arrayList.get(i);
                bl3 = (Boolean)this.groupConfig2Result.get(groupBeanConfig);
                if (bl3 != null) continue;
                bl3 = this.checkGroupCondition(groupBeanConfig) ? Boolean.TRUE : Boolean.FALSE;
                this.groupConfig2Result.put(groupBeanConfig, bl3);
            }
            if (bl3.booleanValue() && !(screen = screenBeanConfig2.getOrInstantiateScreen(false)).isHidden() && !screen.isHiddenForNext() && this.context.runBooleanScript(screenBeanConfig2.getConditionClassName(), screen)) {
                return screenBeanConfig2;
            }
            ++n3;
            bl = true;
        }
        return null;
    }

    private int getScreenIndexWithLoop(int n, Map map) {
        int n2 = 0;
        Stack<GroupInfo> stack = new Stack<GroupInfo>();
        Iterator iterator = this.getScreenConfigs().iterator();
        while (iterator.hasNext() && n2 < n) {
            Object object;
            Object e = iterator.next();
            if (e instanceof GroupBeanConfig) {
                object = (GroupBeanConfig)e;
                stack.push(new GroupInfo(iterator, (GroupBeanConfig)object, n2));
                iterator = ((GroupBeanConfig)object).getBeanConfigs().iterator();
            } else {
                ++n2;
            }
            while (!iterator.hasNext() && !stack.empty()) {
                object = (GroupInfo)stack.peek();
                iterator = ((GroupInfo)object).outerIterator;
                if (n2 == n && Controller.checkAllGroups(map, stack) && this.isGroupLoop(((GroupInfo)object).groupBeanConfig)) {
                    this.resetInitializationOfContainedFormScreens(((GroupInfo)object).groupBeanConfig);
                    HashSet<GroupBeanConfig> hashSet = new HashSet<GroupBeanConfig>(stack.size());
                    Iterator iterator2 = stack.iterator();
                    while (iterator2.hasNext()) {
                        hashSet.add(((GroupInfo)iterator2.next()).groupBeanConfig);
                    }
                    Controller.retainInMap(map, hashSet);
                    return ((GroupInfo)object).firstScreenIndex;
                }
                stack.pop();
            }
        }
        return n;
    }

    private void resetInitializationOfContainedFormScreens(GroupBeanConfig groupBeanConfig) {
        Iterator iterator = groupBeanConfig.getBeanConfigs().iterator();
        while (iterator.hasNext()) {
            AbstractBeanConfig abstractBeanConfig = (AbstractBeanConfig)iterator.next();
            if (abstractBeanConfig instanceof ScreenBeanConfig) {
                Screen screen = ((ScreenBeanConfig)abstractBeanConfig).getOrInstantiateScreen(true);
                if (!(screen instanceof FormScreen)) continue;
                ((FormScreen)screen).resetFormComponents();
                continue;
            }
            if (!(abstractBeanConfig instanceof GroupBeanConfig)) continue;
            this.resetInitializationOfContainedFormScreens((GroupBeanConfig)abstractBeanConfig);
        }
    }

    private static boolean checkAllGroups(Map map, Stack stack) {
        Iterator iterator = stack.iterator();
        while (iterator.hasNext()) {
            GroupInfo groupInfo = (GroupInfo)iterator.next();
            Boolean bl = (Boolean)map.get(groupInfo.groupBeanConfig);
            if (bl == null || bl.booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static void retainInMap(Map map, Set set) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (set.contains(entry.getKey())) continue;
            iterator.remove();
        }
    }

    private boolean isGroupLoop(GroupBeanConfig groupBeanConfig) {
        Group group = groupBeanConfig.getOrInstantiateGroup(false);
        if (group instanceof ControlFlowGroup) {
            try {
                Object object = this.context.runScript(((ControlFlowGroup)group).getLoopExpression(), group, null);
                if (object instanceof Boolean) {
                    return (Boolean)object;
                }
                return false;
            }
            catch (Exception exception) {
                InstallerUtil.reportException(exception);
                return false;
            }
        }
        return false;
    }

    private boolean checkGroupCondition(GroupBeanConfig groupBeanConfig) {
        Group group = groupBeanConfig.getOrInstantiateGroup(false);
        if (group instanceof ControlFlowGroup) {
            try {
                Object object = this.context.runScript(((ControlFlowGroup)group).getConditionExpression(), group, null);
                if (object instanceof Boolean) {
                    return (Boolean)object;
                }
                return true;
            }
            catch (Exception exception) {
                InstallerUtil.reportException(exception);
                return false;
            }
        }
        return true;
    }

    private static boolean addCurrentScreenGroups(ScreenBeanConfig screenBeanConfig, List list, List list2) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AbstractBeanConfig abstractBeanConfig;
            AbstractBeanConfig abstractBeanConfig2 = (AbstractBeanConfig)iterator.next();
            if (abstractBeanConfig2 instanceof ScreenBeanConfig) {
                abstractBeanConfig = (ScreenBeanConfig)abstractBeanConfig2;
                if (abstractBeanConfig != screenBeanConfig) continue;
                return true;
            }
            abstractBeanConfig = (GroupBeanConfig)abstractBeanConfig2;
            if (!Controller.addCurrentScreenGroups(screenBeanConfig, ((GroupBeanConfig)abstractBeanConfig).getBeanConfigs(), list2)) continue;
            list2.add(abstractBeanConfig);
            return true;
        }
        return false;
    }

    private ScreenBeanConfig findPreviousScreenConfig(boolean bl, List list) {
        Object object;
        ScreenBeanConfig screenBeanConfig = null;
        int n = this.screenConfigHistory.size() - 1;
        if (!bl) {
            --n;
        }
        while (n >= 0) {
            screenBeanConfig = (ScreenBeanConfig)this.screenConfigHistory.get(n);
            if (bl) {
                this.screenConfigHistory.remove(n);
            }
            if (!(object = screenBeanConfig.getOrInstantiateScreen(false)).isHiddenForPrevious()) break;
            if (list != null) {
                list.addAll(screenBeanConfig.getActionConfigs());
            }
            --n;
        }
        if (bl && screenBeanConfig != null) {
            object = new ArrayList();
            Controller.addCurrentScreenGroups(screenBeanConfig, this.getScreenConfigs(), (List)object);
            Controller.retainInMap(this.groupConfig2Result, new HashSet(object));
        }
        return screenBeanConfig;
    }

    private int getIndex(ScreenBeanConfig screenBeanConfig) {
        ListIterator listIterator = this.getScreenConfigsFlat().listIterator();
        while (listIterator.hasNext()) {
            ScreenBeanConfig screenBeanConfig2 = (ScreenBeanConfig)listIterator.next();
            if (screenBeanConfig2 != screenBeanConfig) continue;
            return listIterator.previousIndex();
        }
        throw new RuntimeException("not in screen sequence; " + screenBeanConfig);
    }

    private int getIndex(Screen screen) {
        ListIterator listIterator = this.getScreenConfigsFlat().listIterator();
        while (listIterator.hasNext()) {
            ScreenBeanConfig screenBeanConfig = (ScreenBeanConfig)listIterator.next();
            if (screenBeanConfig.getOrInstantiateScreen(false) != screen) continue;
            return listIterator.previousIndex();
        }
        throw new RuntimeException("not in screen sequence; " + screen);
    }

    private List getScreenConfigs() {
        return this.context.getScreenConfigs();
    }

    private List getScreenConfigsFlat() {
        return this.context.getScreenConfigsFlat();
    }

    private static class GroupInfo {
        Iterator outerIterator;
        GroupBeanConfig groupBeanConfig;
        int firstScreenIndex;

        private GroupInfo(Iterator iterator, GroupBeanConfig groupBeanConfig, int n) {
            this.outerIterator = iterator;
            this.groupBeanConfig = groupBeanConfig;
            this.firstScreenIndex = n;
        }
    }
}

