/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.api.windows.WinRegistry;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.LaunchDescriptor;
import com.install4j.runtime.installer.helper.LaunchHelper;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class GUIHelper {
    public static final ImageIcon DEFAULT_ICON_FRAME_16 = GUIHelper.loadIcon("install4j_icon_16.png");
    public static final ImageIcon DEFAULT_ICON_FRAME_32 = GUIHelper.loadIcon("install4j_icon_32.png");
    private static final String ICONS_DIRECTORY = "icons/";
    public static final int BASELINE_LEADING = 512;
    private static boolean lafSet = false;
    private static final Dimension IMAGE_BUTTON_SIZE = new Dimension(28, 28);
    public static final Icon ICON_FOLDER_OPEN = GUIHelper.loadIcon("folder_open.png");
    public static final Icon ICON_FOLDER_CLOSED = GUIHelper.loadIcon("folder_closed.png");
    private static String browserExecutable = "";
    static /* synthetic */ Class class$com$install4j$runtime$installer$frontend$GUIHelper;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$awt$Window;

    public static String getBrowserExecutable() {
        return browserExecutable;
    }

    public static void setBrowserExecutable(String string) {
        browserExecutable = string;
    }

    public static void setLanguage(String string) {
        Object object;
        if (string != null) {
            try {
                Locale.setDefault(new Locale(string, ""));
            }
            catch (Exception exception) {}
        } else {
            string = Locale.getDefault().getLanguage();
        }
        GUIHelper.setLaF();
        if (string.equals("ja") || string.equals("ko") || string.startsWith("zh")) {
            object = UIManager.getFont("Label.font");
            UIManager.put("OptionPane.font", object);
            UIManager.put("OptionPane.messageFont", object);
            UIManager.put("OptionPane.buttonFont", object);
        }
        object = System.getProperty("install4j.font.offset");
        String string2 = System.getProperty("java.version");
        if (object != null) {
            GUIHelper.adjustFontSize(Integer.parseInt((String)object));
        } else if (string.equals("zh_TW") && (string2.startsWith("1.3") || string2.startsWith("1.4"))) {
            GUIHelper.adjustFontSize(2);
        }
    }

    private static boolean isLafFailed() {
        if (Util.isWindows9X()) {
            Object object = WinRegistry.getValue(RegistryRoot.HKEY_CURRENT_USER, "SOFTWARE\\ej-technologies\\exe4j\\", "SettingLaf");
            if (object != null && object instanceof Integer && (Integer)object == 1) {
                WinRegistry.setValue(RegistryRoot.HKEY_CURRENT_USER, "SOFTWARE\\ej-technologies\\exe4j\\", "SettingLaf", new Integer(0));
                return true;
            }
            WinRegistry.setValue(RegistryRoot.HKEY_CURRENT_USER, "SOFTWARE\\ej-technologies\\exe4j\\", "SettingLaf", new Integer(1));
            return false;
        }
        return false;
    }

    private static void setLaFSucceded() {
        if (Util.isWindows9X()) {
            WinRegistry.setValue(RegistryRoot.HKEY_CURRENT_USER, "SOFTWARE\\ej-technologies\\exe4j\\", "SettingLaf", new Integer(0));
        }
    }

    public static void setLaF() {
        if (!lafSet) {
            lafSet = true;
            if (!(GUIHelper.isLafFailed() || Boolean.getBoolean("install4j.nolaf") || InstallerUtil.isConsole() || InstallerUtil.isUnattended() || System.getProperty("swing.defaultlaf") != null)) {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    if (GUIHelper.isGtkLaF() && InstallerUtil.isUpToJava15()) {
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    }
                    GUIHelper.setLaFSucceded();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean isWindowsLaF() {
        return UIManager.getLookAndFeel().getID().equals("Windows");
    }

    public static boolean isWindowsXpLaF() {
        return GUIHelper.isWindowsLaF() && Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive") != null && !Boolean.getBoolean("swing.noxp");
    }

    public static boolean isGtkLaF() {
        return UIManager.getLookAndFeel().getID().equals("GTK");
    }

    public static boolean isAlloyLaF() {
        return UIManager.getLookAndFeel().getID().equals("Alloy");
    }

    private static void adjustFontSize(int n) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        HashMap<Font, Font> hashMap = new HashMap<Font, Font>();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object object = uIDefaults.get(k);
            if (!(object instanceof Font)) continue;
            Font font = (Font)object;
            Font font2 = (Font)hashMap.get(font);
            if (font2 == null) {
                font2 = new Font(font.getName(), font.getStyle(), font.getSize() + n);
                hashMap.put(font, font2);
            }
            linkedList.add(k);
            linkedList.add(font2);
        }
        uIDefaults.putDefaults(linkedList.toArray());
    }

    public static ImageIcon loadIcon(String string) {
        return new ImageIcon((class$com$install4j$runtime$installer$frontend$GUIHelper == null ? (class$com$install4j$runtime$installer$frontend$GUIHelper = GUIHelper.class$("com.install4j.runtime.installer.frontend.GUIHelper")) : class$com$install4j$runtime$installer$frontend$GUIHelper).getResource(ICONS_DIRECTORY + string));
    }

    public static int showOptionDialog(Component component, final String string, final String[] stringArray, final int n) throws UserCanceledException {
        if (InstallerUtil.isUnattended()) {
            return -1;
        }
        if (InstallerUtil.isConsole()) {
            return ConsoleImpl.getInstance().askOption(string, stringArray, null);
        }
        GUIHelper.setLaF();
        final Component component2 = component == null ? GUIHelper.getParentWindow() : component;
        final int[] nArray = new int[1];
        if (SwingUtilities.isEventDispatchThread()) {
            GUIHelper.showOptionDialogInternal(component, string, n, stringArray, nArray);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        GUIHelper.showOptionDialogInternal(component2, string, n, stringArray, nArray);
                    }
                });
            }
            catch (Exception exception) {
                InstallerUtil.reportException(exception);
            }
        }
        return nArray[0];
    }

    private static void showOptionDialogInternal(Component component, String string, int n, String[] stringArray, int[] nArray) {
        nArray[0] = JOptionPane.showOptionDialog(component, string, Messages.getMessages().getString("SetupAppTitle"), 0, n, null, stringArray, stringArray[0]);
    }

    public static Window getParentWindow() {
        if (InstallerUtil.isUnattended() || InstallerUtil.isConsole()) {
            return null;
        }
        Frame[] frameArray = JFrame.getFrames();
        if (frameArray != null) {
            for (int i = 0; i < frameArray.length; ++i) {
                Frame frame = frameArray[i];
                if (!frame.isShowing()) continue;
                return frame;
            }
            if (frameArray.length > 0) {
                return frameArray[0];
            }
        }
        return null;
    }

    public static void showMessage(Component component, final String string, final int n) {
        if (InstallerUtil.isUnattended()) {
            System.err.println(string);
        } else if (InstallerUtil.isConsole()) {
            ConsoleImpl.getInstance().println(string);
        } else {
            Component component2;
            GUIHelper.setLaF();
            Component component3 = component2 = component == null ? GUIHelper.getParentWindow() : component;
            if (SwingUtilities.isEventDispatchThread()) {
                GUIHelper.showMessageInternal(component2, string, n);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            GUIHelper.showMessageInternal(component2, string, n);
                        }
                    });
                }
                catch (Exception exception) {
                    InstallerUtil.reportException(exception);
                }
            }
        }
    }

    private static void showMessageInternal(Component component, String string, int n) {
        JOptionPane.showOptionDialog(component, string, Messages.getMessages().getString("SetupAppTitle"), -1, n, null, new Object[]{Messages.getMessages().getString("ButtonOK")}, null);
    }

    public static void showURL(String string) {
        if (InstallerUtil.isUnattended() || InstallerUtil.isConsole()) {
            return;
        }
        Window window = GUIHelper.getParentWindow();
        if (InstallerUtil.isWindows()) {
            if (string.toLowerCase().indexOf("#") > -1) {
                string = "\"" + string + "\"";
            }
            try {
                Runtime.getRuntime().exec("rundll32.exe url.dll,FileProtocolHandler " + string);
            }
            catch (IOException iOException) {
                GUIHelper.showBrowserError(window);
            }
        } else if (InstallerUtil.isMacOS()) {
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = GUIHelper.class$("java.lang.String")) : class$java$lang$String};
            Object[] objectArray = new Object[]{GUIHelper.encodeSpaces(string)};
            try {
                Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", classArray).invoke(null, objectArray);
            }
            catch (Exception exception) {
                try {
                    Class.forName("com.apple.mrj.MRJFileUtils").getDeclaredMethod("openURL", classArray).invoke(null, objectArray);
                }
                catch (Exception exception2) {
                    GUIHelper.showBrowserError(window);
                }
            }
        } else {
            if (browserExecutable == null || browserExecutable.length() == 0) {
                browserExecutable = "firefox";
            }
            if (!GUIHelper.startBrowser(string, window, false)) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setDialogTitle(Messages.getMessages().getString("LocateBrowerExecutable"));
                if (jFileChooser.showOpenDialog(window) != 0) {
                    return;
                }
                browserExecutable = jFileChooser.getSelectedFile().getPath();
                GUIHelper.startBrowser(string, window, true);
            }
        }
    }

    private static String encodeSpaces(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == ' ') {
                stringBuffer.append("%20");
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private static boolean startBrowser(String string, Window window, boolean bl) {
        if (LaunchHelper.launchFinishExecutable(new File(browserExecutable), new String[]{string}, null) != null) {
            return true;
        }
        browserExecutable = null;
        if (bl) {
            GUIHelper.showBrowserError(window);
        }
        return false;
    }

    private static void showBrowserError(Window window) {
        GUIHelper.showMessage(window, Messages.getMessages().getString("ErrorStartingBrowser"), 0);
    }

    public static List getFrameIconImages() {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        Application application = InstallerConfig.getCurrentApplication();
        if (application.isUseCustomIcon()) {
            try {
                File file;
                ImageIcon imageIcon;
                File file2 = InstallerUtil.getInstallerFile(application.getCustomPngIcon16File().getPath());
                ImageIcon imageIcon2 = new ImageIcon(file2.getPath());
                if (imageIcon2.getIconWidth() > 0) {
                    arrayList.add(imageIcon2.getImage());
                }
                if ((imageIcon = new ImageIcon((file = InstallerUtil.getInstallerFile(application.getCustomPngIcon32File().getPath())).getPath())).getIconWidth() > 0) {
                    arrayList.add(imageIcon.getImage());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (arrayList.size() == 0) {
            arrayList.add(DEFAULT_ICON_FRAME_16.getImage());
            arrayList.add(DEFAULT_ICON_FRAME_32.getImage());
        }
        return arrayList;
    }

    public static void setIconImages(List list, JFrame jFrame) {
        if (InstallerUtil.isUpToJava15()) {
            if (list.size() > 0) {
                jFrame.setIconImage((Image)list.get(0));
            }
        } else {
            try {
                Method method = (class$java$awt$Window == null ? (class$java$awt$Window = GUIHelper.class$("java.awt.Window")) : class$java$awt$Window).getMethod("setIconImages", class$java$util$List == null ? (class$java$util$List = GUIHelper.class$("java.util.List")) : class$java$util$List);
                method.invoke((Object)jFrame, list);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void setIconImages(JFrame jFrame) {
        GUIHelper.setIconImages(GUIHelper.getFrameIconImages(), jFrame);
    }

    public static void showPath(String string) {
        if (InstallerUtil.isUnattended() || InstallerUtil.isConsole()) {
            return;
        }
        File file = new File(string);
        boolean bl = file.isDirectory();
        if (InstallerUtil.isMacOS()) {
            File file2 = bl ? file : file.getParentFile();
            LaunchHelper.launchApplication(new LaunchDescriptor(new File("/usr/bin/open")).arguments(new String[]{file2.getAbsolutePath()}));
        } else {
            String[] stringArray;
            File file3 = null;
            if (InstallerUtil.isWindows()) {
                if (string.indexOf(32) > -1) {
                    string = FolderInfo.getShortPathName(string);
                }
                stringArray = new String[]{"explorer.exe", (bl ? "" : "/select,") + string};
            } else {
                stringArray = new String[]{"/bin/sh", "-c", "xterm"};
                file3 = bl ? file : file.getParentFile();
            }
            try {
                Runtime.getRuntime().exec(stringArray, null, file3);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static int getDelegateBaseline(JComponent jComponent, int n, int n2) {
        if (!InstallerUtil.isAtLeastJava16() || n <= 1 || n2 <= 1) {
            return -1;
        }
        try {
            return (Integer)jComponent.getClass().getMethod("getBaseline", Integer.TYPE, Integer.TYPE).invoke((Object)jComponent, new Integer(n), new Integer(n2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public static void makeImageButton(AbstractButton abstractButton) {
        abstractButton.setText(null);
        abstractButton.setMinimumSize(IMAGE_BUTTON_SIZE);
        abstractButton.setPreferredSize(IMAGE_BUTTON_SIZE);
        abstractButton.setMaximumSize(IMAGE_BUTTON_SIZE);
        if (Util.isMacOS()) {
            abstractButton.putClientProperty("JButton.buttonType", "toolbar");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

