/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.util.ButtonUtil;
import com.install4j.runtime.util.DisplayTextArea;
import com.install4j.runtime.util.KeyboardUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class PasswordDialog
extends JDialog
implements ActionListener {
    private static final Icon ICON = GUIHelper.loadIcon("lock_open.png");
    private static final int TEXT_FIELD_WIDTH = 350;
    private static final int TEXT_FIELD_WIDTH_USER = 250;
    private JButton btnOk;
    private JButton btnCancel;
    private DisplayTextArea displayTextArea;
    private String header;
    private String footer;
    private String title;
    private InputTextValidator inputTextValidator;
    private boolean user;
    private boolean canceled = true;
    private JTextField txtPassword;
    private JTextField txtUser;

    public static String getPassword(Window window, String string, String string2, String string3, InputTextValidator inputTextValidator) {
        PasswordDialog passwordDialog = PasswordDialog.createInputDialog(window, string, string2, string3, inputTextValidator, false);
        passwordDialog.setVisible(true);
        passwordDialog.dispose();
        if (!passwordDialog.isCanceled()) {
            return passwordDialog.getPassword();
        }
        return null;
    }

    public static String[] getUserAndPassword(Window window, String string, String string2, String string3) {
        PasswordDialog passwordDialog = PasswordDialog.createInputDialog(window, string, string2, string3, null, true);
        passwordDialog.setVisible(true);
        passwordDialog.dispose();
        if (!passwordDialog.isCanceled()) {
            return new String[]{passwordDialog.getUser(), passwordDialog.getPassword()};
        }
        return null;
    }

    private static PasswordDialog createInputDialog(Window window, String string, String string2, String string3, InputTextValidator inputTextValidator, boolean bl) {
        PasswordDialog passwordDialog;
        if (window instanceof JDialog) {
            passwordDialog = new PasswordDialog((JDialog)window, string, string2, string3, inputTextValidator, bl);
        } else if (window instanceof JFrame || window == null) {
            passwordDialog = new PasswordDialog((JFrame)window, string, string2, string3, inputTextValidator, bl);
        } else {
            throw new IllegalArgumentException();
        }
        return passwordDialog;
    }

    private PasswordDialog(JFrame jFrame, String string, String string2, String string3, InputTextValidator inputTextValidator, boolean bl) {
        super(jFrame);
        this.init(string, string2, string3, inputTextValidator, bl);
    }

    private PasswordDialog(JDialog jDialog, String string, String string2, String string3, InputTextValidator inputTextValidator, boolean bl) {
        super(jDialog);
        this.init(string, string2, string3, inputTextValidator, bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.btnOk) {
            this.doOk();
        } else if (object == this.btnCancel) {
            this.doCancel();
        }
    }

    public String getPassword() {
        return this.txtPassword.getText();
    }

    public String getUser() {
        return this.txtUser.getText();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.canceled = true;
        }
        super.setVisible(bl);
    }

    private void init(String string, String string2, String string3, InputTextValidator inputTextValidator, boolean bl) {
        this.header = string;
        this.footer = string2;
        this.title = string3;
        this.inputTextValidator = inputTextValidator;
        this.user = bl;
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
        this.setupAccelerators();
    }

    private void setupControls() {
        this.txtPassword = new JPasswordField();
        this.adjustPreferredSize(this.txtPassword);
        this.txtUser = new JTextField();
        this.adjustPreferredSize(this.txtUser);
        this.btnOk = new JButton(Messages.getMessages().getString("ButtonOK"));
        this.btnCancel = new JButton(Messages.getMessages().getString("ButtonCancel"));
    }

    private void adjustPreferredSize(JTextField jTextField) {
        Dimension dimension = jTextField.getPreferredSize();
        dimension.width = this.user ? 250 : 350;
        jTextField.setPreferredSize(dimension);
    }

    private void setupComponent() {
        this.setModal(true);
        this.setTitle(this.title);
        this.setDefaultCloseOperation(0);
        this.setContentPane(this.createContentPanel());
        this.getRootPane().setDefaultButton(this.btnOk);
        this.pack();
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getWidth()) / 2;
        int n2 = (dimension.height - this.getHeight()) / 2;
        this.setLocation(n, n2);
    }

    private JPanel createContentPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(5, 5, 0, 5);
        Insets insets2 = new Insets(0, 5, 0, 5);
        gridBagConstraints.insets = insets;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        jPanel.add((Component)new JLabel(ICON), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        if (this.header != null) {
            jPanel.add((Component)new JLabel(this.header), gridBagConstraints);
        }
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        if (this.user) {
            jPanel.add((Component)new JLabel(Messages.getMessages().getString("UserInfoName")), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = insets2;
            jPanel.add((Component)new JLabel(Messages.getMessages().getString("PasswordEditLabel")), gridBagConstraints);
            --gridBagConstraints.gridy;
            gridBagConstraints.insets = insets;
        }
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        if (this.user) {
            jPanel.add((Component)this.txtUser, gridBagConstraints);
            gridBagConstraints.insets = insets2;
            ++gridBagConstraints.gridy;
        }
        jPanel.add((Component)this.txtPassword, gridBagConstraints);
        gridBagConstraints.insets = insets;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        if (this.footer != null) {
            this.displayTextArea = new DisplayTextArea();
            this.displayTextArea.setText(this.footer);
            jPanel.add((Component)this.displayTextArea, gridBagConstraints);
            ++gridBagConstraints.gridy;
        } else {
            jPanel.add((Component)new JPanel(), gridBagConstraints);
        }
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)ButtonUtil.createHorizontalButtonBox(new Component[]{this.btnOk, this.btnCancel}, 1), gridBagConstraints);
        return jPanel;
    }

    protected void setupEventHandlers() {
        this.btnOk.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PasswordDialog.this.doCancel();
            }

            public void windowActivated(WindowEvent windowEvent) {
                if (PasswordDialog.this.user) {
                    PasswordDialog.this.txtUser.requestFocus();
                } else {
                    PasswordDialog.this.txtPassword.requestFocus();
                }
            }
        });
    }

    private void doOk() {
        if (this.inputTextValidator != null && !this.inputTextValidator.isValidInputText(this.getPassword(), this)) {
            this.txtPassword.requestFocus();
            return;
        }
        this.canceled = false;
        this.setVisible(false);
    }

    private void doCancel() {
        this.canceled = true;
        this.setVisible(false);
    }

    private void setupAccelerators() {
        KeyboardUtil.addAccelerator(1, this.btnCancel, (JComponent)this.getContentPane(), this, 27, 0);
    }

    public static void main(String[] stringArray) {
        PasswordDialog.getPassword(null, "Please enter your password:", "You must be a member of the Administrator group to install a service. You must be a member of the Administrator group to install a service. You must be a member of the Administrator group to install a service.", "Enter Password", null);
        PasswordDialog.getUserAndPassword(null, null, "The site requires that you log in.", "Enter Credentials");
        System.exit(0);
    }

    public static interface InputTextValidator {
        public boolean isValidInputText(String var1, PasswordDialog var2);
    }
}

