/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.screens.FormPanelContainer;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.screens.SystemScreen;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.ActionCallback;
import com.install4j.runtime.installer.controller.FinishCommand;
import com.install4j.runtime.installer.controller.GoBackCommand;
import com.install4j.runtime.installer.controller.GoForwardCommand;
import com.install4j.runtime.installer.frontend.FormPanel;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.WizardScreenExecutor;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.wizard.StandardScreen;
import com.install4j.runtime.wizard.WizardBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ScreenEnvelope
extends StandardScreen
implements ActionCallback {
    private static final Icon ICON_WIZARD = GUIHelper.loadIcon("wizard.png");
    private static final Object ORIGINAL_SIZE = "originalSize";
    private static int nextId;
    private WizardScreenExecutor wizard;
    private Screen screen;
    private ScreenBeanConfig config;
    private FormPanel formPanel;
    private boolean lastForwardEnabled;
    private boolean lastPreviousEnabled;
    private Map formComponentToEnabledStatus = new HashMap();

    public ScreenEnvelope(WizardScreenExecutor wizardScreenExecutor, Screen screen, ScreenBeanConfig screenBeanConfig) {
        super(wizardScreenExecutor);
        this.wizard = wizardScreenExecutor;
        this.screen = screen;
        this.config = screenBeanConfig;
        this.init();
    }

    protected ScreenEnvelope(Screen screen) {
        super((WizardBase)null);
        this.screen = screen;
    }

    public FormPanel getFormPanel() {
        return this.formPanel;
    }

    protected void init() {
        this.setName(String.valueOf(nextId++));
        this.initFormPanel();
        this.initScreen();
    }

    protected void initFormPanel() {
        if (this.screen instanceof FormPanelContainer) {
            this.formPanel = this.createFormPanel();
            ((FormPanelContainer)((Object)this.screen)).setFormPanel(this.formPanel, this.formPanel.getFormEnvironment());
        }
    }

    protected FormPanel createFormPanel() {
        return new FormPanel(this.config.getFormComponentConfigs(), this.wizard.getContext(), this.isBannerPainted(), this.screen);
    }

    public Screen getScreen() {
        return this.screen;
    }

    public void actionsStarted() {
        this.lastForwardEnabled = this.getForwardButton().isEnabled();
        this.lastPreviousEnabled = this.getPreviousButton().isEnabled();
        final ArrayList<FormComponent> arrayList = new ArrayList<FormComponent>();
        if (this.formPanel != null) {
            FormComponent[] formComponentArray = this.formPanel.getFormEnvironment().getFormComponents();
            for (int i = 0; i < formComponentArray.length; ++i) {
                FormComponent formComponent = formComponentArray[i];
                if (!formComponent.hasUserInput()) continue;
                this.formComponentToEnabledStatus.put(formComponent, formComponent.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
                arrayList.add(formComponent);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ScreenEnvelope.this.getForwardButton().setEnabled(false);
                ScreenEnvelope.this.getPreviousButton().setEnabled(false);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ((FormComponent)iterator.next()).setEnabled(false);
                }
            }
        });
    }

    public void actionsFinished() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ScreenEnvelope.this.getForwardButton().setEnabled(ScreenEnvelope.this.lastForwardEnabled);
                ScreenEnvelope.this.getPreviousButton().setEnabled(ScreenEnvelope.this.lastPreviousEnabled);
                if (ScreenEnvelope.this.formPanel != null) {
                    Iterator iterator = ScreenEnvelope.this.formComponentToEnabledStatus.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        ((FormComponent)entry.getKey()).setEnabled((Boolean)entry.getValue());
                    }
                    ScreenEnvelope.this.formComponentToEnabledStatus.clear();
                }
            }
        });
    }

    public void activate() {
        this.wizard.getContext().runBooleanScript(this.config.getPreActivationClassName(), this.screen, this.createScriptParameters());
        this.screen.willActivate();
        if (this.formPanel != null) {
            this.formPanel.willActivate();
        }
        this.updateTitleAndSubtitle();
        super.activate();
        this.screen.activated();
        if (this.formPanel != null) {
            this.formPanel.activated();
        }
        this.wizard.getContext().runBooleanScript(this.config.getPostActivationClassName(), this.screen, this.createScriptParameters());
    }

    public void deactivate() {
        super.deactivate();
        this.screen.deactivated();
        if (this.formPanel != null) {
            this.formPanel.deactivated();
        }
    }

    public void setNextButtonEnabled(boolean bl) {
        this.getForwardButton().setEnabled(bl);
    }

    public void setPreviousButtonEnabled(boolean bl) {
        this.getPreviousButton().setEnabled(bl);
    }

    public void setCancelButtonEnabled(boolean bl) {
        this.getCancelButton().setEnabled(bl);
    }

    public void setNextButtonVisible(boolean bl) {
        this.getForwardButton().setVisible(bl);
    }

    public void setPreviousButtonVisible(boolean bl) {
        this.getPreviousButton().setVisible(bl);
    }

    public void setCancelButtonVisible(boolean bl) {
        this.getCancelButton().setVisible(bl);
    }

    public void gotoNextScreen() {
        if (this.getForwardButton().isVisible() && this.getForwardButton().isEnabled()) {
            this.actionPerformed(new ActionEvent(this.getForwardButton(), 0, ""));
        }
    }

    public void gotoPreviousScreen() {
        if (this.getPreviousButton().isVisible() && this.getPreviousButton().isEnabled()) {
            this.actionPerformed(new ActionEvent(this.getPreviousButton(), 0, ""));
        }
    }

    protected boolean hasTitlePanel() {
        return this.screen.hasTitlePanel();
    }

    protected boolean isBannerPainted() {
        return this.screen instanceof SystemScreen && ((SystemScreen)this.screen).isBannerPainted();
    }

    protected String getBannerIconFileName() {
        return this.screen instanceof SystemScreen ? ((SystemScreen)this.screen).getBannerIconFileName() : null;
    }

    protected Color getBannerBackground() {
        Color color;
        if (this.screen instanceof SystemScreen && (color = ((SystemScreen)this.screen).getBannerBackground()) != null) {
            return color;
        }
        return super.getBannerBackground();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.getPreviousButton()) {
            if (this.isEnabledAndVisible(this.getPreviousButton())) {
                this.doPrevious();
            }
        } else if (object == this.getForwardButton()) {
            if (this.isEnabledAndVisible(this.getForwardButton())) {
                this.doNext();
            }
        } else if (object == this.getCancelButton() && this.isEnabledAndVisible(this.getCancelButton())) {
            this.doCancel();
        }
    }

    private boolean isEnabledAndVisible(JButton jButton) {
        return jButton.isEnabled() && jButton.isVisible();
    }

    void doCancel() {
        if (this.screen.cancel()) {
            this.cancelWizard();
        }
    }

    void doNext() {
        if (this.screen.next() && this.checkFormCompleted() && this.wizard.getContext().runBooleanScript(this.config.getValidationClassName(), this.screen, this.createScriptParameters())) {
            if (this.isFinishScreen()) {
                this.screen.deactivated();
                this.wizard.getCommandSink().returnToController(new FinishCommand(this));
            } else {
                this.wizard.getCommandSink().returnToController(new GoForwardCommand(1, true, true, this));
            }
        }
    }

    private Object[] createScriptParameters() {
        Object[] objectArray = this.formPanel != null ? new Object[]{this.formPanel.getFormEnvironment()} : null;
        return objectArray;
    }

    void doPrevious() {
        if (this.screen.previous()) {
            if (this.formPanel != null) {
                this.formPanel.previous();
            }
            this.wizard.getCommandSink().returnToController(new GoBackCommand(1, true));
        }
    }

    protected void cancelWizard() {
        this.wizard.cancel();
    }

    private boolean checkFormCompleted() {
        return this.formPanel == null || this.formPanel.checkCompleted();
    }

    public boolean isFinishScreen() {
        return this.config == null || this.config.isFinishScreen();
    }

    public boolean isCancelVisible() {
        return this.screen.isCancelVisible() && !this.isFinishScreen();
    }

    protected boolean supportsPrevious() {
        return !this.screen.isHidden() && !this.screen.isHiddenForPrevious();
    }

    protected boolean supportsNext() {
        return !this.screen.isHidden() && !this.screen.isHiddenForNext();
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        if (this.screen.isFillHorizontal()) {
            gridBagConstraints.fill = 2;
        }
        if (this.screen.isFillVertical()) {
            gridBagConstraints.fill = 3;
        }
        if (this.screen.isFillHorizontal() && this.screen.isFillVertical()) {
            gridBagConstraints.fill = 1;
        }
        jPanel.add((Component)this.screen.createComponent(), gridBagConstraints);
        this.getPreviousButton().setVisible(this.screen.isPreviousVisible());
        this.getForwardButton().setVisible(this.screen.isNextVisible() || this.isFinishScreen());
        this.getCancelButton().setVisible(this.isCancelVisible());
        if (this.isFinishScreen()) {
            this.getForwardButton().setText(this.getMessages().getString("ButtonFinish"));
        }
    }

    protected String getTitle() {
        return this.screen.getTitle();
    }

    protected String getSubTitle() {
        return this.screen.getSubTitle();
    }

    protected boolean needsSpacer() {
        return !this.screen.isFillVertical();
    }

    protected Icon getBannerIcon() {
        Icon icon = ICON_WIZARD;
        String string = this.getBannerIconFileName();
        if (string != null) {
            try {
                icon = new ImageIcon(InstallerUtil.getInstallerFile(string).getPath());
                if (icon.getIconWidth() <= 0) {
                    return ICON_WIZARD;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return icon;
    }

    protected Icon getHeaderIcon() {
        return this.wizard.getHeaderIcon();
    }

    protected ResourceBundle getMessages() {
        return Messages.getMessages();
    }

    protected JButton createCancelButton() {
        return new JButton(this.getMessages().getString("ButtonCancel"));
    }

    protected JButton createForwardButton() {
        return new JButton(this.getMessages().getString("ButtonNext") + " >");
    }

    protected JButton createPreviousButton() {
        return new JButton("< " + this.getMessages().getString("ButtonBack"));
    }

    public boolean isCancelButtonEnabled() {
        return this.getCancelButton().isEnabled();
    }

    protected String getWatermarkText() {
        Application application = InstallerConfig.getCurrentApplication();
        if (this.isBannerPainted() || !application.isWatermark()) {
            return null;
        }
        String string = application.getCustomWatermarkText().trim();
        return string.length() == 0 ? "install4j " : string;
    }

    public void disarmButtons() {
        this.disarmButton(this.getForwardButton());
        this.disarmButton(this.getPreviousButton());
        this.disarmButton(this.getCancelButton());
    }

    private void disarmButton(JButton jButton) {
        jButton.getModel().setArmed(false);
        jButton.getModel().setPressed(false);
    }

    public void focusNextButton() {
        this.getForwardButton().requestFocus();
    }

    public void setNextButtonText(String string) {
        this.setButtonText(string, this.getForwardButton());
    }

    public void setPreviousButtonText(String string) {
        this.setButtonText(string, this.getPreviousButton());
    }

    public void setCancelButtonText(String string) {
        this.setButtonText(string, this.getCancelButton());
    }

    private void setButtonText(String string, JButton jButton) {
        Dimension dimension = (Dimension)jButton.getClientProperty(ORIGINAL_SIZE);
        Dimension dimension2 = jButton.getPreferredSize();
        if (dimension == null) {
            dimension = (Dimension)dimension2.clone();
            jButton.putClientProperty(ORIGINAL_SIZE, dimension);
        }
        jButton.setPreferredSize(null);
        jButton.setText(string);
        dimension2.width = Math.max(jButton.getPreferredSize().width, dimension.width);
        jButton.setPreferredSize(dimension2);
        jButton.setMinimumSize(dimension2);
        jButton.setMaximumSize(dimension2);
    }
}

