/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.GUIProgressInterface;
import com.install4j.runtime.installer.frontend.components.ProgressDisplay;
import com.install4j.runtime.wizard.CustomFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class SplashProgressInterface
extends CustomFrame
implements ProgressInterface {
    private final GUIProgressInterface guiProgressInterface = new GUIProgressInterface();
    private ProgressDisplay progressDisplay;
    private boolean userConfirmations;
    private boolean quietOverwrite;

    public SplashProgressInterface(String string, boolean bl, boolean bl2) {
        this.userConfirmations = bl;
        this.quietOverwrite = bl2;
        this.progressDisplay = new ProgressDisplay();
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add((Component)this.progressDisplay, "Center");
        this.setTitle(string);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.setBounds(this.getNewFrameBounds());
        GUIHelper.setIconImages(this);
    }

    protected int getFrameHeight() {
        return 110;
    }

    protected int getFrameWidth() {
        return 350;
    }

    public void setStatusMessage(String string) {
        this.progressDisplay.setStatusMessage(string);
    }

    public void setDetailMessage(String string) {
        this.progressDisplay.setDetailMessage(string);
    }

    public void setPercentCompleted(int n) {
        this.progressDisplay.setPercentCompleted(n);
    }

    public int getPercentCompleted() {
        return this.progressDisplay.getPercentCompleted();
    }

    public void setIndeterminateProgress(boolean bl) {
        this.progressDisplay.setIndeterminateProgress(bl);
    }

    public void showFailure(String string) {
        if (this.userConfirmations) {
            this.guiProgressInterface.showFailure(string);
        }
    }

    public int askOverwrite(File file) throws UserCanceledException {
        if (this.userConfirmations) {
            return this.guiProgressInterface.askOverwrite(file);
        }
        if (this.quietOverwrite) {
            return 2;
        }
        return 1;
    }

    public int askRetry(File file) throws UserCanceledException {
        if (this.userConfirmations) {
            return this.guiProgressInterface.askRetry(file);
        }
        return 1;
    }

    public boolean askContinue(File file) throws UserCanceledException {
        if (this.userConfirmations) {
            return this.guiProgressInterface.askContinue(file);
        }
        return true;
    }
}

