/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.headless;

import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.FormPanelContainer;
import com.install4j.api.screens.Screen;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.config.ScreenBeanConfig;
import com.install4j.runtime.installer.controller.FinishCommand;
import com.install4j.runtime.installer.controller.ReturnToken;
import com.install4j.runtime.installer.frontend.FormPanel;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.SplashProgressInterface;
import com.install4j.runtime.installer.frontend.headless.AbstractHeadlessScreenExecutor;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import java.io.File;
import java.util.List;
import java.util.Locale;
import javax.swing.SwingUtilities;

public abstract class UnattendedScreenExecutor
extends AbstractHeadlessScreenExecutor {
    private ProgressInterface progressInterface;
    private boolean quietOverwrite;
    private int wait;
    private String splash;
    private boolean suppressStdout;
    private boolean detailStdout;

    public UnattendedScreenExecutor(boolean bl, int n, String string) {
        this.quietOverwrite = bl;
        this.wait = n;
        this.splash = string;
        this.suppressStdout = Boolean.getBoolean("install4j.suppressStdout");
        this.detailStdout = Boolean.getBoolean("install4j.detailStdout");
        this.init(string == null);
    }

    protected boolean handleScreen(ScreenBeanConfig screenBeanConfig) {
        if (this.wait > 0) {
            try {
                boolean bl = false;
                for (int i = 0; i < this.wait; ++i) {
                    if (RunningProcessChecker.checkRunningProcesses(ContextImpl.getSingleContextImpl(), null, true)) {
                        bl = true;
                        break;
                    }
                    Thread.sleep(1000L);
                }
                if (!bl) {
                    System.err.println(Messages.getMessages().getString("UnattendedRunningFailure"));
                    System.exit(-1);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (UserCanceledException userCanceledException) {
                // empty catch block
            }
            this.wait = 0;
        }
        Object[] objectArray = null;
        Screen screen = screenBeanConfig.getOrInstantiateScreen(false);
        if (screen instanceof FormPanelContainer) {
            FormPanel formPanel = new FormPanel(screenBeanConfig.getFormComponentConfigs(), this.getContext(), false, screen);
            ((FormPanelContainer)((Object)screen)).setFormPanel(formPanel, formPanel.getFormEnvironment());
            if (!formPanel.handleUnattended()) {
                return false;
            }
            objectArray = new Object[]{formPanel.getFormEnvironment()};
        }
        if (screen.isHidden() || screen.isHiddenForNext()) {
            return true;
        }
        if (!screen.handleUnattended()) {
            return false;
        }
        this.getContext().runBooleanScript(screenBeanConfig.getPreActivationClassName(), screen, objectArray);
        boolean bl = this.getContext().runBooleanScript(screenBeanConfig.getValidationClassName(), screen, objectArray);
        if (screenBeanConfig.isFinishScreen()) {
            this.getCommandSink().returnToController(new FinishCommand(null));
        }
        return bl;
    }

    public boolean isUnattended() {
        return true;
    }

    public boolean isConsole() {
        return false;
    }

    public ProgressInterface getProgressInterface() {
        if (this.progressInterface == null) {
            if (this.splash == null) {
                this.progressInterface = new UnattendedProgressInterface();
            } else {
                Runnable runnable = new Runnable(){

                    public void run() {
                        GUIHelper.setLaF();
                        UnattendedScreenExecutor.this.progressInterface = new SplashProgressInterface(UnattendedScreenExecutor.this.splash, false, UnattendedScreenExecutor.this.quietOverwrite);
                        ((SplashProgressInterface)UnattendedScreenExecutor.this.progressInterface).setVisible(true);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    try {
                        SwingUtilities.invokeAndWait(runnable);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        this.progressInterface = new UnattendedProgressInterface();
                    }
                }
            }
        }
        return this.progressInterface;
    }

    public void selectLanguage(ReturnToken returnToken) {
        String string = null;
        List list = InstallerConfig.getCurrentInstance().getLanguages();
        String string2 = Locale.getDefault().getLanguage();
        LanguageConfig languageConfig = InstallerConfig.getCurrentInstance().getLanguageById(string2);
        if (languageConfig != null) {
            string = languageConfig.getId();
        } else if (list.size() > 0) {
            string = ((LanguageConfig)list.get(0)).getId();
        }
        returnToken.returnToController(string);
    }

    private class UnattendedProgressInterface
    implements ProgressInterface {
        private UnattendedProgressInterface() {
        }

        public void setStatusMessage(String string) {
            if (!UnattendedScreenExecutor.this.suppressStdout) {
                ConsoleImpl.getInstance().setStatusMessage(string);
            }
        }

        public void setDetailMessage(String string) {
            if (UnattendedScreenExecutor.this.detailStdout) {
                ConsoleImpl.getInstance().setDetailMessage(string);
            }
        }

        public void setPercentCompleted(int n) {
        }

        public int getPercentCompleted() {
            return 0;
        }

        public void setIndeterminateProgress(boolean bl) {
        }

        public void showFailure(String string) {
            ConsoleImpl.getInstance().showFailure(string);
        }

        public int askOverwrite(File file) {
            if (UnattendedScreenExecutor.this.quietOverwrite) {
                return 2;
            }
            return 1;
        }

        public int askRetry(File file) {
            return 1;
        }

        public boolean askContinue(File file) {
            return true;
        }
    }
}

