/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.exe4j.runtime.util.ResourceHelper;
import com.install4j.api.Util;
import com.install4j.api.windows.WinEnvVars;
import com.install4j.runtime.beans.applications.Application;
import com.install4j.runtime.beans.applications.ExecutionMode;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.ClasspathModificator;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.installer.platform.win32.Registry;
import com.install4j.runtime.util.StringUtil;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;

public class InstallerUtil {
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    public static final boolean DEBUG = Boolean.getBoolean("install4j.debug");
    public static final String REGKEY_EXE4J = "SOFTWARE\\ej-technologies\\exe4j\\";
    private static final String REGVAL_INSTALL_STARTED = "InstallStarted";
    public static final String REGVAL_SETTING_LAF = "SettingLaf";
    private static boolean unattended = false;
    private static boolean console = false;
    private static boolean deployLibsLodaded = false;

    public static boolean isUnattended() {
        return unattended;
    }

    public static void setUnattended(boolean bl) {
        unattended = bl;
    }

    public static boolean isConsole() {
        return console;
    }

    public static void setConsole(boolean bl) {
        console = bl;
    }

    public static boolean isSolaris() {
        return OS_NAME.equals("SunOS");
    }

    public static boolean isSolarisSparc() {
        return InstallerUtil.isSolaris() && OS_ARCH.equals("sparc");
    }

    public static boolean isLinux() {
        return OS_NAME.toLowerCase().startsWith("linux");
    }

    public static boolean isLinuxX86() {
        return InstallerUtil.isLinux() && OS_ARCH.indexOf("86") > -1;
    }

    public static boolean isWindows() {
        return OS_NAME.toLowerCase().startsWith("win");
    }

    public static boolean isWindowsXP() {
        return OS_NAME.toLowerCase().startsWith("windows xp");
    }

    public static boolean isWindows2000() {
        return OS_NAME.toLowerCase().startsWith("windows 2000");
    }

    public static boolean isMacOS() {
        return OS_NAME.toLowerCase().startsWith("mac");
    }

    public static boolean isWindowsMe() {
        return OS_NAME.startsWith("Windows Me");
    }

    public static boolean isWindows9X() {
        return OS_NAME.startsWith("Windows 98") || OS_NAME.startsWith("Windows 95") || OS_NAME.startsWith("Windows Me") || OS_NAME.startsWith("Windows (unknown)");
    }

    public static boolean isWindowsNT() {
        return (OS_NAME.toLowerCase().startsWith("windows nt") || OS_NAME.toLowerCase().startsWith("windowsnt")) && !OS_VERSION.startsWith("6");
    }

    public static boolean isAtLeastWindowsVista() {
        try {
            return InstallerUtil.isWindows() && Double.parseDouble(OS_VERSION.substring(0, 2)) >= 6.0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isWindowsVista() {
        return OS_NAME.toLowerCase().startsWith("windows vista") || OS_NAME.toLowerCase().startsWith("windows nt") && OS_VERSION.startsWith("6");
    }

    public static boolean isWindows7() {
        return OS_NAME.toLowerCase().startsWith("windows 7") || OS_NAME.toLowerCase().startsWith("windows vista") && OS_VERSION.startsWith("6.1");
    }

    public static boolean isWindows2003() {
        return OS_NAME.toLowerCase().startsWith("windows") && OS_NAME.indexOf("2003") > -1;
    }

    public static boolean isWindows2008() {
        return OS_NAME.toLowerCase().startsWith("windows") && OS_NAME.indexOf("2008") > -1;
    }

    public static boolean isHpux() {
        return OS_NAME.equals("HP-UX");
    }

    public static boolean isAix() {
        return OS_NAME.equals("AIX");
    }

    public static boolean isUpToJava15() {
        String string = System.getProperty("java.version");
        return string.startsWith("1.2") || string.startsWith("1.3") || string.startsWith("1.4") || string.startsWith("1.5");
    }

    public static String getStandardApplicationsDirectory() {
        if (InstallerUtil.isWindows()) {
            return FolderInfo.getProgramFilesDirectory().getAbsolutePath();
        }
        if (InstallerUtil.isMacOS()) {
            return "/Applications";
        }
        File file = new File("/opt");
        String[] stringArray = file.list();
        String string = file.exists() && stringArray != null && stringArray.length > 0 ? "/opt" : "/usr/local";
        File file2 = new File(string);
        if (file2.exists() && file2.canWrite()) {
            return string;
        }
        return System.getProperty("user.home");
    }

    public static File getInstallerFile(String string) {
        File file;
        if ("installer".equals(InstallerConfig.getCurrentApplicationId()) && (file = new File(string).getAbsoluteFile()).exists()) {
            return file;
        }
        file = new File(ResourceHelper.getRuntimeDir(), string);
        if (file.exists() || !Util.isMacOS()) {
            return file;
        }
        return new File(string).getAbsoluteFile();
    }

    public static synchronized void loadJREDeployLibs() {
        if (deployLibsLodaded) {
            return;
        }
        if (InstallerUtil.isWindows() && !InstallerUtil.isWindows9X() && !InstallerUtil.isWindowsNT()) {
            File file;
            File file2;
            File file3;
            String string = System.getProperty("java.home");
            File file4 = new File(string, "lib");
            File file5 = new File(file4, "deploy.jar");
            if (file5.exists()) {
                ClasspathModificator.addClassPath(file5);
            }
            if ((file3 = new File(file4, "plugin.jar")).exists()) {
                ClasspathModificator.addClassPath(file3);
            }
            if ((file2 = new File(file = new File(string, "bin"), "deploy.dll")).exists()) {
                try {
                    System.load(file2.getPath());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            deployLibsLodaded = true;
        }
    }

    public static ExecutionMode getExecutionMode(CommandLineOptions commandLineOptions, boolean bl) {
        Application application = InstallerConfig.getCurrentApplication();
        ExecutionMode executionMode = application.getExecutionMode();
        String string = System.getProperty("install4j.executionMode");
        if ("gui".equals(string)) {
            executionMode = ExecutionMode.GUI;
        } else if ("console".equals(string)) {
            executionMode = ExecutionMode.CONSOLE;
        } else if ("unattended".equals(string)) {
            executionMode = ExecutionMode.UNATTENDED;
        }
        if (commandLineOptions.quiet && (application.isAllowUnattended() || bl)) {
            executionMode = ExecutionMode.UNATTENDED;
        } else if (commandLineOptions.console && application.isAllowConsole()) {
            executionMode = ExecutionMode.CONSOLE;
        } else if (commandLineOptions.gui) {
            executionMode = ExecutionMode.GUI;
        }
        if (executionMode == ExecutionMode.GUI && Util.isUnixInstaller() && application.isAllowConsole() && application.isUnixFallbackToConsole()) {
            try {
                new Frame();
            }
            catch (Throwable throwable) {
                executionMode = ExecutionMode.CONSOLE;
            }
        }
        return executionMode;
    }

    public static String getSupportedSystemLanguageId() {
        Logger logger = Logger.getInstance();
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        logger.info(null, "System language '" + string + "'");
        if (InstallerConfig.getCurrentInstance().getLanguageById(string) != null) {
            return string;
        }
        string = string + "_" + locale.getCountry();
        logger.info(null, "System locale '" + string + "'");
        if (InstallerConfig.getCurrentInstance().getLanguageById(string) != null) {
            return string;
        }
        logger.info(null, "System locale not found in available languages");
        return null;
    }

    public static boolean is64BitWindows() {
        return InstallerUtil.is64BitWindowsArch(WinEnvVars.getenv("PROCESSOR_ARCHITECTURE")) || InstallerUtil.is64BitWindowsArch(WinEnvVars.getenv("PROCESSOR_ARCHITEW6432"));
    }

    private static boolean is64BitWindowsArch(String string) {
        return string != null && (string.equalsIgnoreCase("AMD64") || string.equalsIgnoreCase("IA64"));
    }

    public static CommandLineOptions parseCommandLine(String[] stringArray) {
        Object object;
        String string = (String)VersionSpecificHelper.getenv().get("INSTALL4J_ARGUMENTS");
        if (string != null) {
            object = new ArrayList();
            StringUtil.splitupQuotedList((List)object, string, " ");
            stringArray = object.toArray(new String[object.size()]);
        }
        object = new CommandLineOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string2 = stringArray[i];
            if (string2.equals("-q") && !((CommandLineOptions)object).console && !((CommandLineOptions)object).gui) {
                ((CommandLineOptions)object).quiet = true;
                continue;
            }
            if (string2.equals("-c") && !((CommandLineOptions)object).quiet && !((CommandLineOptions)object).gui) {
                ((CommandLineOptions)object).console = true;
                continue;
            }
            if (string2.equals("-g") && !((CommandLineOptions)object).console && !((CommandLineOptions)object).quiet) {
                ((CommandLineOptions)object).gui = true;
                continue;
            }
            if (string2.equals("-overwrite")) {
                ((CommandLineOptions)object).quietOverwrite = true;
                continue;
            }
            if (string2.equals("-dir") && i + 1 < stringArray.length) {
                ((CommandLineOptions)object).installDir = new File(stringArray[++i]);
                continue;
            }
            if (string2.equals("-wait") && i + 1 < stringArray.length) {
                ((CommandLineOptions)object).wait = Integer.parseInt(stringArray[++i]);
                continue;
            }
            if (string2.equals("-varfile") && i + 1 < stringArray.length) {
                ((CommandLineOptions)object).varFileName = stringArray[++i];
                continue;
            }
            if (string2.equals("-splash") && i + 1 < stringArray.length) {
                ((CommandLineOptions)object).splash = stringArray[++i];
                continue;
            }
            boolean bl = string2.startsWith("-D");
            boolean bl2 = string2.startsWith("-V");
            if (!bl && !bl2 || (n = string2.indexOf(61)) <= -1 || string2.length() <= n + 1) continue;
            String string3 = string2.substring(2, n);
            String string4 = string2.substring(n + 1);
            if (bl) {
                System.setProperty(string3, string4);
                continue;
            }
            ((CommandLineOptions)object).commandLineVars.setProperty(string3, string4);
        }
        return object;
    }

    private static List getAddOnApplicationConfigsFromRuntimeDir(File file) {
        ArrayList<InstallerConfig> arrayList = new ArrayList<InstallerConfig>();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.getName().startsWith("i4jparams.conf.")) continue;
                try {
                    arrayList.add(InstallerConfig.getGeneralConfigFromFile(file2));
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return arrayList;
    }

    public static List getAddOnApplicationConfigs(File file) {
        if (file.exists()) {
            File file2 = new File(file, ".install4j/i4jparams.conf");
            if (file2.exists()) {
                try {
                    return InstallerUtil.getAddOnApplicationConfigsFromRuntimeDir(file2.getParentFile());
                }
                catch (Exception exception) {
                }
            } else if (Util.isMacOS() && (file2 = new File(file, "Contents/Resources/app/.install4j/i4jparams.conf")).exists()) {
                try {
                    return InstallerUtil.getAddOnApplicationConfigsFromRuntimeDir(file2.getParentFile());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static InstallerConfig getOldApplicationConfig(File file) {
        if (file.exists()) {
            File file2 = new File(file, ".install4j/i4jparams.conf");
            if (file2.exists()) {
                try {
                    return InstallerConfig.getGeneralConfigFromFile(file2);
                }
                catch (Exception exception) {
                }
            } else if (Util.isMacOS() && (file2 = new File(file, "Contents/Resources/app/.install4j/i4jparams.conf")).exists()) {
                try {
                    return InstallerConfig.getGeneralConfigFromFile(file2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static String getOldApplicationId(File file) {
        InstallerConfig installerConfig = InstallerUtil.getOldApplicationConfig(file);
        if (installerConfig != null) {
            if (installerConfig.getApplicationId().indexOf("${") > -1) {
                return null;
            }
            return installerConfig.getApplicationId();
        }
        return null;
    }

    public static boolean checkWritable(File file, Component component, boolean bl) {
        Serializable serializable;
        ArrayList<File> arrayList = new ArrayList<File>();
        for (serializable = file; serializable != null; serializable = ((File)serializable).getParentFile()) {
            arrayList.add((File)serializable);
        }
        serializable = new ArrayList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            File file2 = (File)arrayList.get(i);
            if (!file2.mkdir()) continue;
            serializable.add(file2);
        }
        File file3 = new File(file, "i4j_writeperm_test");
        file3.delete();
        boolean bl2 = file3.mkdir();
        file3.delete();
        for (int i = serializable.size() - 1; i >= 0; --i) {
            File file4 = (File)serializable.get(i);
            file4.delete();
        }
        if (!bl2 && bl) {
            GUIHelper.showMessage(component, Messages.getMessages().getString("NoWritePermissions"), 2);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadFile(File file, String string) {
        if (file == null) return null;
        if (!file.exists()) {
            return null;
        }
        try {
            if (!file.getName().toLowerCase().endsWith(".zip")) return InstallerUtil.readString(new FileInputStream(file));
            ZipFile zipFile = new ZipFile(file);
            try {
                ZipEntry zipEntry;
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                do {
                    if (!enumeration.hasMoreElements()) return null;
                } while (!(zipEntry = enumeration.nextElement()).getName().startsWith(string + "."));
                String string2 = InstallerUtil.readString(zipFile.getInputStream(zipEntry));
                return string2;
            }
            finally {
                zipFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String readString(InputStream inputStream) throws IOException {
        int n;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        StringWriter stringWriter = new StringWriter();
        while ((n = inputStreamReader.read()) != -1) {
            stringWriter.write(n);
        }
        inputStreamReader.close();
        return stringWriter.toString();
    }

    public static String sanitizeHTML(String string) {
        boolean bl;
        String string2 = string.toLowerCase();
        boolean bl2 = bl = string2.indexOf("<html>") > -1;
        if (bl) {
            int n = string2.indexOf("<head>");
            int n2 = string2.indexOf("</head>");
            if (n > -1 && n2 > n) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string.substring(0, n));
                stringBuffer.append(string.substring(n + 6, n2));
                stringBuffer.append(string.substring(n2 + 7));
                string = stringBuffer.toString();
            }
        }
        return string;
    }

    public static String cleanupName(String string) {
        if (string.endsWith("//") || string.endsWith("\\\\")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static void reportException(Throwable throwable) {
        Logger.getInstance().log(throwable);
        if (DEBUG) {
            System.err.println(Util.getAnnotatedStackTrace(throwable));
        } else {
            Object object;
            Object object2;
            Object object3;
            File file = null;
            try {
                file = File.createTempFile("install4jError", ".log");
                object3 = new PrintWriter(new FileOutputStream(file));
                ((PrintWriter)object3).println("Exception:");
                ((PrintWriter)object3).println();
                ((PrintWriter)object3).print(Util.getAnnotatedStackTrace(throwable));
                ((PrintWriter)object3).println();
                ((PrintWriter)object3).println("System properties:");
                ((PrintWriter)object3).println();
                object2 = System.getProperties().entrySet().iterator();
                while (object2.hasNext()) {
                    object = (Map.Entry)object2.next();
                    ((PrintWriter)object3).print(object.getKey());
                    ((PrintWriter)object3).print("=");
                    ((PrintWriter)object3).println(object.getValue());
                }
                ((PrintWriter)object3).flush();
                ((PrintWriter)object3).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (file != null) {
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            object3 = "An error occurred:\n" + throwable + "\nError log: " + (file == null ? "" : file.getPath());
            object2 = new StringWriter();
            throwable.printStackTrace(new PrintWriter((Writer)object2, true));
            object = ((StringWriter)object2).toString();
            if (unattended) {
                System.err.println((String)object3);
                throwable.printStackTrace();
            } else if (console) {
                ConsoleImpl.getInstance().println(object3);
                ConsoleImpl.getInstance().printStackTrace(throwable);
            } else if (((String)object).indexOf("X11") > 0) {
                InstallerUtil.displayXMessage();
            } else {
                try {
                    JOptionPane.showMessageDialog(null, object3, "install4j", 0);
                }
                catch (Throwable throwable2) {
                    if (Util.isWindowsInstaller() || Boolean.getBoolean("install4j.suppressX11Message")) {
                        System.err.println((String)object3);
                        throwable.printStackTrace();
                    }
                    InstallerUtil.displayXMessage();
                }
            }
        }
    }

    public static boolean isAtLeastJava14() {
        String string = System.getProperty("java.version");
        return !string.startsWith("1.3") && !string.startsWith("1.2");
    }

    public static boolean isAtLeastJava15() {
        String string = System.getProperty("java.version");
        return !string.startsWith("1.4") && !string.startsWith("1.3") && !string.startsWith("1.2");
    }

    public static boolean isAtLeastJava16() {
        String string = System.getProperty("java.version");
        return !string.startsWith("1.5") && !string.startsWith("1.4") && !string.startsWith("1.3") && !string.startsWith("1.2");
    }

    private static void displayXMessage() {
        System.err.println("Could not display the GUI. This application needs access to an X Server.");
        if (InstallerUtil.isAtLeastJava14()) {
            if (InstallerConfig.getCurrentApplication().isAllowConsole()) {
                System.err.println("*******************************************************************");
                System.err.println("You can also run this application in console mode without");
                System.err.println("access to an X server by passing the argument -c");
                System.err.println("*******************************************************************");
            } else if (InstallerConfig.getCurrentApplication().isAllowUnattended()) {
                System.err.println("*******************************************************************");
                System.err.println("You can also run this application in unattended mode without");
                System.err.println("access to an X server by passing the argument -q");
                System.err.println("*******************************************************************");
            }
        }
    }

    public static void registerStarted() {
        if (InstallerUtil.isWindows()) {
            Registry.setValue(2, REGKEY_EXE4J, REGVAL_INSTALL_STARTED, new Integer(0));
        }
    }

    public static boolean checkJavaVersion() {
        if (InstallerUtil.isMacOS()) {
            InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
            String string = installerConfig.getMinJavaVersion();
            if (string.trim().equals("")) {
                return true;
            }
            if (System.getProperty("java.version").compareTo(string) >= 0) {
                return true;
            }
            String string2 = MessageFormat.format(Messages.getMessages().getString("AppleJavaMinVersionError"), installerConfig.getMinJavaVersion(), installerConfig.getApplicationName());
            GUIHelper.showMessage(null, string2, 0);
            return false;
        }
        return true;
    }

    public static String getVerboseVariableDefinition(String string, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("=");
        stringBuffer.append(object);
        if (object != null) {
            stringBuffer.append("[");
            stringBuffer.append(object.getClass());
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public static String getAnnotatedStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (installerConfig == null) {
            return stringWriter.toString();
        }
        return VersionSpecificHelper.insertBeanNames(stringWriter.toString(), installerConfig.getClassNameToScriptClassOrigin());
    }

    public static class CommandLineOptions {
        public boolean quiet = false;
        public boolean console = false;
        public boolean gui = false;
        public File installDir = null;
        public boolean quietOverwrite = false;
        public int wait = 0;
        public String splash = null;
        public Properties commandLineVars = new Properties();
        public String varFileName;
    }
}

