/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.api.Util;
import com.install4j.api.windows.WinFileSystem;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.LaunchDescriptor;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.installer.platform.macos.VolumeInfo;
import com.install4j.runtime.installer.platform.unix.UnixUserInfo;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.util.StreamConsumerThread;
import com.install4j.runtime.util.StringUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class LaunchHelper {
    public static final long LAUNCH_EXIT_DELTA_TIME = 10000L;
    private static long lastLaunchTime;
    private static char[] SPECIAL_BATCH_FILE_CHARACTERS;

    public static long getLastLaunchTime() {
        return lastLaunchTime;
    }

    private LaunchHelper() {
    }

    public static Process launchFinishExecutable(File file, String[] stringArray, File file2) {
        Process process = Util.isWindows() || Util.isMacOS() ? LaunchHelper.launchApplication(new LaunchDescriptor(file).workingDirectory(file2).arguments(stringArray).asOriginalUser(true)) : LaunchHelper.launchApplication(new LaunchDescriptor(new File("/bin/sh")).workingDirectory(file2).arguments(new String[]{"-c", "nohup \"" + (file.exists() ? file.getAbsolutePath() : file.getPath()) + "\" " + StringUtil.makeCommandLine(stringArray) + " > /dev/null 2>&1"}));
        if (process != null) {
            lastLaunchTime = System.currentTimeMillis();
        }
        return process;
    }

    public static Process launchApplication(LaunchDescriptor launchDescriptor) {
        Process process = null;
        File file = launchDescriptor.getExecutable();
        String[] stringArray = LaunchHelper.getEnvironmentVariables(launchDescriptor.getSpecificEnvironmentVariables(), launchDescriptor.isIncludeParentEnvironmentVariables());
        try {
            if (file == null) {
                Logger.getInstance().error(null, "executable is null");
            } else if (InstallerUtil.isMacOS()) {
                process = LaunchHelper.launchOnMacOS(launchDescriptor, stringArray);
            } else if (!file.exists() || file.isFile()) {
                String string = file.exists() ? file.getAbsolutePath() : file.getPath();
                process = Util.isWindows() && (string.toLowerCase().endsWith(".bat") || string.toLowerCase().endsWith(".cmd") || Util.isAtLeastWindowsVista() || launchDescriptor.isShowWindowsConsole()) ? LaunchHelper.launchOnWindows(launchDescriptor, string, stringArray) : LaunchHelper.launchOtherwise(launchDescriptor, string, stringArray);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            } else {
                Logger.getInstance().error(null, "executable is not a file: " + file);
            }
            if (launchDescriptor.isConsumeOutput()) {
                StreamConsumerThread.consumeOutput(process);
            }
        }
        catch (IOException iOException) {
            try {
                Logger.getInstance().error(null, iOException.getMessage());
            }
            catch (Exception exception) {
                // empty catch block
            }
            iOException.printStackTrace();
        }
        return process;
    }

    private static Process launchOnMacOS(LaunchDescriptor launchDescriptor, String[] stringArray) throws IOException {
        Object object;
        File file = launchDescriptor.getExecutable();
        if ((file = LaunchHelper.checkDmg(file)) == null) {
            return null;
        }
        if (file.isDirectory()) {
            file = new File(file, "Contents/MacOS/JavaApplicationStub");
        }
        File file2 = LaunchHelper.createMacStartScript(launchDescriptor, file);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (launchDescriptor.isAsOriginalUser() && UnixUserInfo.ROOT_USER && (object = (String)VersionSpecificHelper.getenv().get("SUDO_USER")) != null) {
            arrayList.add("su");
            arrayList.add("-");
            arrayList.add((String)object);
        }
        if (arrayList.isEmpty()) {
            arrayList.add("/bin/sh");
        }
        arrayList.add(file2.getAbsolutePath());
        object = Runtime.getRuntime().exec(arrayList.toArray(new String[arrayList.size()]), stringArray, launchDescriptor.getWorkingDirectory());
        if (object == null) {
            Logger.getInstance().error(null, "process is null");
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return object;
    }

    private static File createMacStartScript(LaunchDescriptor launchDescriptor, File file) throws IOException {
        String[] stringArray = launchDescriptor.getArguments();
        File file2 = File.createTempFile("i4j", ".sh", new File("/tmp"));
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file2)), "UTF-8"));
        printWriter.println("#!/bin/sh");
        printWriter.print("\"" + file.getAbsolutePath() + "\"");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                printWriter.print(" \"" + stringArray[i] + "\"");
            }
        }
        printWriter.println();
        printWriter.println("exitCode=$?");
        printWriter.println("rm $0");
        printWriter.println("exit $exitCode");
        printWriter.close();
        return file2;
    }

    private static Process launchOnWindows(LaunchDescriptor launchDescriptor, String string, String[] stringArray) throws IOException {
        boolean bl;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Util.isWindows9X()) {
            arrayList.add(new File(WinFileSystem.getWindowsDirectory(), "command.com").getAbsolutePath());
        } else {
            try {
                arrayList.add(new File(WinFileSystem.getSystemDirectory(), "cmd.exe").getAbsolutePath());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                arrayList.add("cmd.exe");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                arrayList.add("cmd.exe");
            }
        }
        boolean bl2 = bl = launchDescriptor.isShowWindowsConsole() && !Util.isWindows9X();
        if (bl && launchDescriptor.isKeepConsoleWindow()) {
            arrayList.add("/K");
        } else {
            arrayList.add("/C");
        }
        String string2 = string;
        try {
            string2 = FolderInfo.getShortPathName(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        File file = LaunchHelper.createWindowsStartScript(launchDescriptor, string2);
        arrayList.add("\"" + file.getAbsolutePath() + "\"");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            stringBuffer.append(arrayList.get(i));
            if (i >= arrayList.size() - 1) continue;
            stringBuffer.append(" ");
        }
        String string3 = stringBuffer.toString();
        if (bl) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("start \"");
            stringBuffer2.append(string);
            stringBuffer2.append("\" /WAIT ");
            stringBuffer2.append(string3);
            return Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", stringBuffer2.toString()}, stringArray, launchDescriptor.getWorkingDirectory());
        }
        return Runtime.getRuntime().exec(string3, stringArray, launchDescriptor.getWorkingDirectory());
    }

    private static File createWindowsStartScript(LaunchDescriptor launchDescriptor, String string) throws IOException {
        File file = File.createTempFile("i4j", ".bat");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        printWriter.println("@ECHO OFF");
        printWriter.print("\"" + string + "\"");
        String[] stringArray = launchDescriptor.getArguments();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = StringUtil.replace(stringArray[i], "%", "%%");
                if (LaunchHelper.needsQuotes(string2)) {
                    printWriter.print(" \"" + string2 + "\"");
                    continue;
                }
                printWriter.print(" " + string2);
            }
        }
        printWriter.println();
        printWriter.close();
        file.deleteOnExit();
        return file;
    }

    private static boolean needsQuotes(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c <= 'z' && Arrays.binarySearch(SPECIAL_BATCH_FILE_CHARACTERS, c) < 0) continue;
            return true;
        }
        return false;
    }

    private static Process launchOtherwise(LaunchDescriptor launchDescriptor, String string, String[] stringArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (launchDescriptor.isUseNohup()) {
            arrayList.add("/bin/sh");
            arrayList.add("-c");
            arrayList.add("nohup \"" + string + "\" " + StringUtil.makeCommandLine(launchDescriptor.getArguments()) + " > /dev/null 2>&1");
        } else {
            arrayList.add(string);
            String[] stringArray2 = launchDescriptor.getArguments();
            if (stringArray2 != null) {
                arrayList.addAll(Arrays.asList(stringArray2));
            }
        }
        return Runtime.getRuntime().exec(arrayList.toArray(new String[arrayList.size()]), stringArray, launchDescriptor.getWorkingDirectory());
    }

    private static String[] getEnvironmentVariables(Map map, boolean bl) {
        String string;
        String string2;
        Map.Entry entry;
        if (map == null || map.isEmpty()) {
            if (bl) {
                return null;
            }
            return new String[0];
        }
        Map map2 = VersionSpecificHelper.getenv();
        Map map3 = LaunchHelper.getUpperCaseVariables(map2);
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl2 = InstallerUtil.isWindows();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            string2 = InstallerVariables.replaceVariables((String)entry.getKey());
            string = InstallerVariables.replaceVariables((String)entry.getValue());
            hashSet.add(bl2 ? string2.toUpperCase() : string2);
            arrayList.add(string2 + "=" + LaunchHelper.replaceEnvironmentVariables(string, bl2 ? map3 : map2));
        }
        if (bl) {
            iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                string2 = (String)entry.getKey();
                string = (String)entry.getValue();
                if (hashSet.contains(bl2 ? string2.toUpperCase() : string2)) continue;
                arrayList.add(string2 + "=" + string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static Map getUpperCaseVariables(Map map) {
        HashMap hashMap = new HashMap(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            hashMap.put(((String)entry.getKey()).toUpperCase(), entry.getValue());
        }
        return hashMap;
    }

    private static String replaceEnvironmentVariables(String string, final Map map) {
        return StringUtil.replaceVariable(string, "${", "}", new StringUtil.ReplacementCallback(){

            public String getReplacement(String string, Object object) {
                return (String)map.get(InstallerUtil.isWindows() ? string.toUpperCase() : string);
            }
        });
    }

    private static File checkDmg(File file) throws IOException {
        if ((file = file.getCanonicalFile()).getName().endsWith(".dmg")) {
            Process process = LaunchHelper.launchApplication(new LaunchDescriptor(new File("/usr/bin/hdiutil")).arguments(new String[]{"attach", file.getAbsolutePath()}));
            if (process == null) {
                Logger.getInstance().error(null, "could not execute hdiutil");
                return null;
            }
            try {
                if (process.waitFor() == 0) {
                    Map map = VolumeInfo.getMountPointToDiskFile();
                    if (map != null) {
                        for (int i = 0; i < 5; ++i) {
                            Iterator iterator = map.entrySet().iterator();
                            while (iterator.hasNext()) {
                                File file2;
                                File[] fileArray;
                                Map.Entry entry = iterator.next();
                                if (!new File((String)entry.getValue()).getCanonicalFile().equals(file) || (fileArray = (file2 = new File((String)entry.getKey())).listFiles()) == null) continue;
                                for (int j = 0; j < fileArray.length; ++j) {
                                    File file3 = fileArray[j];
                                    if (!file3.isDirectory() || !file3.getName().endsWith(".app")) continue;
                                    return file3;
                                }
                                Logger.getInstance().error(null, "could not find app bundle");
                                return null;
                            }
                            Thread.sleep(500L);
                            map = VolumeInfo.getNewMountPointToDiskFile();
                        }
                        Logger.getInstance().error(null, "could not find mount point");
                    } else {
                        Logger.getInstance().error(null, "could not retrieve mount points");
                    }
                } else {
                    Logger.getInstance().error(null, "could not mount dmg file");
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return null;
        }
        return file;
    }

    static {
        SPECIAL_BATCH_FILE_CHARACTERS = new char[]{' ', '&', '(', ')', '[', ']', '{', '}', '^', '=', ';', '!', '+', '`', '~', '<', '>', '@', '|'};
        Arrays.sort(SPECIAL_BATCH_FILE_CHARACTERS);
    }
}

