/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.context.Context;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.content.HttpAuthenticator;
import com.install4j.runtime.installer.helper.content.ProxyConfig;
import com.install4j.runtime.installer.helper.versionspecific.ProxyHostInfo;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.text.NumberFormat;

public class Downloader {
    public static final int MODE_GUI = 1;
    public static final int MODE_CONSOLE = 2;
    public static final int MODE_UNATTENDED = 3;
    private static final String SYSPROP_SHOW_PROXY_CONFIG = "install4j.showProxyConfig";
    private static ProxyConfig proxyConfig = new ProxyConfig();
    private long totalProgress = 0L;
    private long totalSize;
    private String totalSizeVerbose;
    private NumberFormat numberFormat;
    private ProgressInterface progressInterface;
    private Context context;
    private boolean askForProxy;
    long startTime;
    long lastProgressUpdateTime = 0L;
    long currentFileProgress;
    private int mode;

    public static ProxyConfig getProxyConfig() {
        return proxyConfig;
    }

    public Downloader(Context context, ProgressInterface progressInterface, boolean bl) {
        this(context.isUnattended() ? 3 : (context.isConsole() ? 2 : 1), progressInterface);
        this.context = context;
        this.askForProxy = bl;
    }

    public Downloader(int n, ProgressInterface progressInterface) {
        this.progressInterface = progressInterface;
        this.mode = n;
        this.numberFormat = NumberFormat.getNumberInstance();
        this.numberFormat.setMaximumFractionDigits(1);
        this.numberFormat.setMinimumFractionDigits(1);
        this.totalSize = -1L;
    }

    public void setTotalSize(long l) {
        this.totalSize = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File download(File file, String string, long l, boolean bl) throws IOException, UserCanceledException {
        try {
            URL uRL = new URL(string);
            URLConnection uRLConnection = this.getURLConnection(uRL);
            long l2 = uRLConnection.getContentLength();
            if (l2 == -1L) {
                l2 = l;
            }
            if (this.totalSize == -1L) {
                this.totalSize = l2;
            }
            this.totalSizeVerbose = this.format(this.totalSize, 0x100000L);
            if (this.progressInterface != null) {
                this.progressInterface.setIndeterminateProgress(false);
            }
            this.updateProgress(true);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                this.startTime = System.currentTimeMillis();
                this.currentFileProgress = 0L;
                long l3 = FileUtil.pumpStream(uRLConnection.getInputStream(), fileOutputStream, new FileUtil.CopyProgressListener(){

                    public boolean progressPerformed(long l) {
                        Downloader.this.currentFileProgress += l;
                        Downloader.this.totalProgress += l;
                        if (Downloader.this.context != null && Downloader.this.context.isCancelling()) {
                            return false;
                        }
                        Downloader.this.updateProgress(false);
                        return true;
                    }
                });
                if (this.context != null && this.context.isCancelling()) {
                    throw new UserCanceledException();
                }
                if (l3 != l2 && l2 != -1L) {
                    throw new IOException("file size not correct: " + l3 + ", expected: " + l2);
                }
                this.updateProgress(true);
            }
            finally {
                ((OutputStream)fileOutputStream).close();
                if (bl) {
                    file.deleteOnExit();
                }
            }
            return file;
        }
        catch (IOException iOException) {
            if (this.mode == 3) {
                System.err.println(iOException.getMessage());
            }
            this.totalProgress -= this.currentFileProgress;
            throw iOException;
        }
    }

    private void updateProgress(boolean bl) {
        if (this.progressInterface == null) {
            return;
        }
        long l = System.currentTimeMillis();
        if (this.totalSize > -1L && (bl || l - this.lastProgressUpdateTime > 500L)) {
            long l2 = (long)((double)this.currentFileProgress / (double)(l - this.startTime) * 1000.0);
            this.progressInterface.setDetailMessage(MessageFormat.format(Messages.getMessages().getString("DownloadProgress"), this.format(this.totalProgress, 0x100000L), this.totalSizeVerbose, this.format(100L * this.totalProgress, this.totalSize), this.format(l2, 1024L)));
            this.progressInterface.setPercentCompleted((int)(this.totalProgress * 100L / this.totalSize));
            this.lastProgressUpdateTime = l;
        }
    }

    private String format(long l, long l2) {
        double d = (double)l / (double)l2;
        return this.numberFormat.format(d);
    }

    private URLConnection getURLConnection(URL uRL) throws IOException, UserCanceledException {
        ProxyHostInfo proxyHostInfo = VersionSpecificHelper.getProxyHostInfo(uRL);
        if (proxyHostInfo != null) {
            proxyConfig.update(proxyHostInfo);
        }
        HttpAuthenticator.setDownloader(this);
        while (true) {
            if (this.context != null && this.context.isCancelling()) {
                throw new UserCanceledException();
            }
            try {
                if (Boolean.getBoolean(SYSPROP_SHOW_PROXY_CONFIG) || !InstallerUtil.isAtLeastJava15() && proxyConfig.isProxySet() && proxyConfig.isPasswordRequired()) {
                    System.setProperty(SYSPROP_SHOW_PROXY_CONFIG, "false");
                    this.askForProxyPassword();
                }
                URLConnection uRLConnection = uRL.openConnection();
                proxyConfig.updateConnection(uRLConnection);
                uRLConnection.connect();
                return uRLConnection;
            }
            catch (IOException iOException) {
                if (this.mode == 3 || !this.askForProxy) {
                    throw iOException;
                }
                proxyConfig.show(this.mode == 2, false);
                if (!proxyConfig.isCanceled()) continue;
                throw new UserCanceledException();
            }
            break;
        }
    }

    public void askForProxyPassword() throws IOException, UserCanceledException {
        if (this.mode == 3 && System.getProperty("proxyAuthPassword") != null) {
            return;
        }
        if (this.mode == 3 || !this.askForProxy) {
            throw new IOException(Messages.getMessages().getString("ProxyPasswordRequired"));
        }
        proxyConfig.show(this.mode == 2, true);
        if (proxyConfig.isCanceled()) {
            throw new UserCanceledException();
        }
    }

    public int getMode() {
        return this.mode;
    }
}

