/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.api.Util;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.PasswordDialog;
import com.install4j.runtime.installer.helper.ConsoleImpl;
import com.install4j.runtime.installer.helper.content.Downloader;
import com.install4j.runtime.installer.helper.content.ProxyConfig;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class HttpAuthenticator
extends Authenticator {
    private static HttpAuthenticator authenticator;
    private static final String SYSPROP_SERVER_AUTH_USER = "serverAuthUser";
    private static final String SYSPROP_SERVER_AUTH_PASSWORD = "serverAuthPassword";
    private Downloader downloader;
    private int currentConnection;
    private int lastAuthConnection;

    public static synchronized HttpAuthenticator getInstance() {
        if (authenticator == null) {
            authenticator = new HttpAuthenticator();
            Authenticator.setDefault(authenticator);
        }
        return authenticator;
    }

    public static void setDownloader(Downloader downloader) {
        HttpAuthenticator httpAuthenticator = HttpAuthenticator.getInstance();
        httpAuthenticator.downloader = downloader;
        ++httpAuthenticator.currentConnection;
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        if (this.downloader == null) {
            return null;
        }
        if (VersionSpecificHelper.isServerAuthentication()) {
            return this.getServerAuthentication();
        }
        return this.getProxyAuthentication();
    }

    private PasswordAuthentication getServerAuthentication() {
        if (System.getProperty(SYSPROP_SERVER_AUTH_USER) != null && this.lastAuthConnection != this.currentConnection) {
            this.lastAuthConnection = this.currentConnection;
            return new PasswordAuthentication(System.getProperty(SYSPROP_SERVER_AUTH_USER), System.getProperty(SYSPROP_SERVER_AUTH_PASSWORD).toCharArray());
        }
        if (this.downloader.getMode() == 1) {
            String[] stringArray = PasswordDialog.getUserAndPassword(Util.getParentWindow(), null, this.getCredentialsMessage(), Messages.getMessages().getString("EnterCredentialsTitle"));
            if (stringArray != null) {
                return new PasswordAuthentication(stringArray[0], stringArray[1].toCharArray());
            }
        } else if (this.downloader.getMode() == 2) {
            ConsoleImpl consoleImpl = ConsoleImpl.getInstance();
            ResourceBundle resourceBundle = Messages.getMessages();
            consoleImpl.println(this.getCredentialsMessage());
            try {
                String string = consoleImpl.askString(resourceBundle.getString("UserName"), "");
                String string2 = consoleImpl.askPassword(resourceBundle.getString("Password"), "");
                return new PasswordAuthentication(string, string2.toCharArray());
            }
            catch (UserCanceledException userCanceledException) {}
        } else if (this.downloader.getMode() == 3 && System.getProperty(SYSPROP_SERVER_AUTH_USER) == null) {
            System.err.println(Messages.getMessages().getString("ServerPasswordRequired"));
        }
        return null;
    }

    private PasswordAuthentication getProxyAuthentication() {
        block3: {
            try {
                this.downloader.askForProxyPassword();
                ProxyConfig proxyConfig = Downloader.getProxyConfig();
                if (!proxyConfig.isCanceled()) {
                    return new PasswordAuthentication(proxyConfig.getAuthUser(), proxyConfig.getAuthPassword().toCharArray());
                }
            }
            catch (Exception exception) {
                if (this.downloader.getMode() != 3) break block3;
                System.err.println(exception.getMessage());
            }
        }
        return null;
    }

    private String getCredentialsMessage() {
        return MessageFormat.format(Messages.getMessages().getString("EnterCredentialsLabel"), VersionSpecificHelper.getRequestingSite());
    }
}

