/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.fileinst;

import com.install4j.api.context.UninstallMode;
import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.helper.fileinst.BackupPair;
import com.install4j.runtime.installer.helper.fileinst.InstallFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import nanoxml.XMLElement;

public class FileLogger {
    private SortedSet createdDirs = new TreeSet(new ReverseComparator());
    private Set createdFiles = new HashSet();
    private List replacedFiles = new ArrayList();
    private static final String ELEMENT_FILELOG = "fileLog";
    private static final String ELEMENT_CREATED_FILES = "createdFiles";
    private static final String ELEMENT_CREATED_DIRS = "createdDirs";
    private static final String ELEMENT_ENTRY = "entry";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_SHARED = "shared";
    private static final String ATTRIBUTE_DONT_UNINSTALL = "dontUninstall";
    private static final String ATTRIBUTE_UNINSTALL_MODE = "uninstallMode";

    public void write(File file, FileLogger fileLogger) throws IOException {
        Object object;
        Object object2;
        Object object3;
        if (fileLogger != null) {
            object3 = fileLogger.getCreatedFilesIterator();
            while (object3.hasNext()) {
                object2 = (InstallFile)object3.next();
                this.addCreatedFile((InstallFile)object2);
            }
            object3 = fileLogger.getCreatedDirsIterator();
            while (object3.hasNext()) {
                object2 = (InstallFile)object3.next();
                this.addCreatedDir((InstallFile)object2);
            }
        }
        object3 = this.replacedFiles.iterator();
        while (object3.hasNext()) {
            object2 = (BackupPair)object3.next();
            object = ((BackupPair)object2).getOriginalFile().getUninstallMode();
            if (object == UninstallMode.ALWAYS || object == UninstallMode.ALWAYS_BUT_NOT_FOR_UPDATE) {
                this.addCreatedFile(((BackupPair)object2).getOriginalFile());
                continue;
            }
            if (((BackupPair)object2).isPreviouslyCreated()) continue;
            this.addOverwrittenFile(((BackupPair)object2).getOriginalFile());
        }
        object3 = new XMLElement();
        ((XMLElement)object3).setName(ELEMENT_FILELOG);
        object2 = new XMLElement();
        ((XMLElement)object2).setName(ELEMENT_CREATED_FILES);
        ((XMLElement)object3).addChild((XMLElement)object2);
        this.addEntries((XMLElement)object2, this.createdFiles);
        object = new XMLElement();
        ((XMLElement)object).setName(ELEMENT_CREATED_DIRS);
        ((XMLElement)object3).addChild((XMLElement)object);
        this.addEntries((XMLElement)object, this.createdDirs);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        ((XMLElement)object3).write(outputStreamWriter);
        outputStreamWriter.close();
    }

    private void addEntries(XMLElement xMLElement, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            this.addEntry(xMLElement, file);
        }
    }

    private void addEntry(XMLElement xMLElement, File file) {
        int n;
        XMLElement xMLElement2 = new XMLElement();
        xMLElement2.setName(ELEMENT_ENTRY);
        String string = file.getAbsolutePath();
        String string2 = ContextImpl.getSingleContextImpl().getInstallationDirectory().getPath();
        if (string.startsWith(string2 + File.separator)) {
            for (n = string2.length(); n < string.length() && string.charAt(n) == File.separatorChar; n += 1) {
            }
            string = string.substring(n);
        } else if (string.equals(string2)) {
            string = ".";
        }
        xMLElement2.setAttribute(ATTRIBUTE_NAME, string);
        n = 0;
        UninstallMode uninstallMode = UninstallMode.IF_CREATED;
        if (file instanceof InstallFile) {
            InstallFile installFile = (InstallFile)file;
            uninstallMode = installFile.getUninstallMode();
            n = installFile.isShared() ? 1 : 0;
        }
        xMLElement2.setAttribute(ATTRIBUTE_UNINSTALL_MODE, String.valueOf(uninstallMode.getIntValue()));
        xMLElement2.setAttribute(ATTRIBUTE_SHARED, String.valueOf(n != 0));
        xMLElement.addChild(xMLElement2);
    }

    public void read(File file) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        XMLElement xMLElement = new XMLElement();
        xMLElement.parseFromReader(inputStreamReader);
        inputStreamReader.close();
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            if (xMLElement2.getName().equals(ELEMENT_CREATED_FILES)) {
                this.readEntries(xMLElement2, this.createdFiles);
                continue;
            }
            if (!xMLElement2.getName().equals(ELEMENT_CREATED_DIRS)) continue;
            this.readEntries(xMLElement2, this.createdDirs);
        }
    }

    private void readEntries(XMLElement xMLElement, Collection collection) {
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            int n = xMLElement2.getIntAttribute(ATTRIBUTE_UNINSTALL_MODE, -1);
            if (n == -1) {
                boolean bl = Boolean.valueOf(xMLElement2.getStringAttribute(ATTRIBUTE_DONT_UNINSTALL, "false"));
                n = bl ? 1 : 0;
            }
            String string = xMLElement2.getStringAttribute(ATTRIBUTE_NAME);
            File file = ContextImpl.getSingleContextImpl().getInstallationDirectory().getAbsoluteFile();
            if (string.equals(".")) {
                string = file.getPath();
            } else if (!new File(string).isAbsolute()) {
                File file2 = new File(file, string);
                string = file2.getPath();
            }
            collection.add(new InstallFile(string, (boolean)Boolean.valueOf(xMLElement2.getStringAttribute(ATTRIBUTE_SHARED, "false")), UninstallMode.getFromIntValue(n)));
        }
    }

    public Iterator getCreatedDirsIterator() {
        return this.createdDirs.iterator();
    }

    public Iterator getCreatedFilesIterator() {
        return this.createdFiles.iterator();
    }

    public List getReplacedFiles() {
        return this.replacedFiles;
    }

    public int getCreatedDirsSize() {
        return this.createdDirs.size();
    }

    public int getCreatedFilesSize() {
        return this.createdFiles.size();
    }

    public void addCreatedDir(InstallFile installFile) {
        installFile = new InstallFile(installFile.getAbsoluteFile(), installFile.isShared(), installFile.getUninstallMode());
        this.createdDirs.add(installFile);
    }

    public void addCreatedFile(InstallFile installFile) {
        installFile = new InstallFile(installFile.getAbsoluteFile(), installFile.isShared(), installFile.getUninstallMode());
        this.createdFiles.add(installFile);
    }

    private void addOverwrittenFile(InstallFile installFile) {
        installFile = new InstallFile(installFile.getAbsoluteFile(), installFile.isShared(), UninstallMode.NEVER);
        this.createdFiles.add(installFile);
    }

    public void addReplacedFile(BackupPair backupPair) {
        this.replacedFiles.add(backupPair);
    }

    public boolean containsCreatedFile(File file) {
        return this.createdFiles.contains(file.getAbsoluteFile());
    }

    public boolean containsCreatedDir(File file) {
        return this.createdDirs.contains(file.getAbsoluteFile());
    }

    public boolean hasFiles() {
        return this.createdDirs.size() > 0 || this.createdFiles.size() > 0 || this.replacedFiles.size() > 0;
    }

    private static class ReverseComparator
    implements Comparator {
        private ReverseComparator() {
        }

        public int compare(Object object, Object object2) {
            return -((Comparable)object).compareTo(object2);
        }
    }
}

