/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.registry;

import com.install4j.runtime.installer.ContextImpl;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.registry.NoRegistry;
import com.install4j.runtime.installer.helper.registry.RegistryInterface;
import com.install4j.runtime.installer.helper.registry.Win32Registry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class InstallRegistry {
    private static final String REGVAL_PREFIX_INST_DIR = "instdir";
    private static final String REGVAL_PREFIX_ALL_INST_DIR = "allinstdirs";
    private static final String REGVAL_PREFIX_SINGLE_BUNDLE_NAME = "singleBundleName";
    private static final String DELIMITER = ";";
    private static RegistryInterface registry;

    public static boolean isNoPreferences() {
        return Boolean.getBoolean("noPreferences") || ContextImpl.getSingleContextImpl() != null && ContextImpl.getSingleContextImpl().getBooleanVariable("sys.noPreferences");
    }

    public static void registerApplication(String string, File file, String string2) {
        InstallRegistry.init();
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        String string3 = registry.getValue(REGVAL_PREFIX_INST_DIR + string);
        InstallRegistry.unregisterApplication(string, file);
        String string4 = REGVAL_PREFIX_ALL_INST_DIR + string;
        String string5 = registry.getValue(string4);
        if (string5 == null) {
            if (string3 != null && string3.trim().length() > 0) {
                try {
                    File file2 = new File(string3).getCanonicalFile();
                    if (!file2.equals(file)) {
                        string5 = file.getAbsolutePath() + DELIMITER + file2.getAbsolutePath();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (string5 == null) {
                string5 = file.getAbsolutePath();
            }
        } else {
            string5 = file.getAbsolutePath() + DELIMITER + string5;
        }
        registry.setValue(string4, string5);
        registry.setValue(REGVAL_PREFIX_INST_DIR + string, file.getAbsolutePath());
        if (string2 != null) {
            registry.setValue(REGVAL_PREFIX_SINGLE_BUNDLE_NAME + string + "_" + file.getAbsolutePath(), string2);
        }
    }

    public static void unregisterApplication(String string, File file) {
        InstallRegistry.init();
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        registry.deleteValue(REGVAL_PREFIX_INST_DIR + string);
        String string2 = REGVAL_PREFIX_ALL_INST_DIR + string;
        String string3 = registry.getValue(string2);
        String string4 = "";
        if (string3 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, DELIMITER);
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                try {
                    if (new File(string5).getCanonicalFile().equals(file)) continue;
                    string4 = string4 + string5 + DELIMITER;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (string4.equals("")) {
            registry.deleteValue(string2);
        } else {
            registry.setValue(string2, string4);
        }
        registry.deleteValue(REGVAL_PREFIX_SINGLE_BUNDLE_NAME + string + "_" + file.getAbsolutePath());
    }

    public static String getInstallationDir(String string) {
        String[] stringArray = InstallRegistry.getAllInstallationDirs(string);
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public static String[] getAllInstallationDirs(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = InstallRegistry.getValue(REGVAL_PREFIX_ALL_INST_DIR + string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, DELIMITER);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3 == null || string3.trim().length() <= 0) continue;
                arrayList.add(string3);
            }
        } else {
            String string4 = InstallRegistry.getValue(REGVAL_PREFIX_INST_DIR + string);
            if (string4 != null && string4.trim().length() > 0) {
                arrayList.add(string4);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String getSingleBundleName(String string, String string2) {
        try {
            return InstallRegistry.getValue(REGVAL_PREFIX_SINGLE_BUNDLE_NAME + string + "_" + new File(string2).getCanonicalFile());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static String getValue(String string) {
        InstallRegistry.init();
        return registry.getValue(string);
    }

    public static void setValue(String string, String string2) {
        InstallRegistry.init();
        registry.deleteValue(string);
        registry.setValue(string, string2);
    }

    private static void init() {
        if (registry == null) {
            if (InstallerUtil.isWindows()) {
                registry = new Win32Registry();
            } else if (System.getProperty("java.version").compareTo("1.3") <= 0 || InstallRegistry.isNoPreferences()) {
                registry = new NoRegistry();
            } else {
                try {
                    registry = (RegistryInterface)Class.forName("com.install4j.runtime.installer.helper.registry.PreferencesRegistry").newInstance();
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
            }
        }
    }
}

