/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.versionspecific;

import com.install4j.runtime.installer.helper.versionspecific.FileDropListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.JTextField;

public class FileDrop {
    private static final boolean SUPPORTS_DND;
    private DropTargetListener dropListener;

    public FileDrop(JTextField jTextField) {
        this(jTextField, null);
    }

    public FileDrop(final Component component, final FileDropListener fileDropListener) {
        if (SUPPORTS_DND) {
            this.dropListener = new DropTargetListener(){

                public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                    if (FileDrop.this.isDragOk(dropTargetDragEvent)) {
                        dropTargetDragEvent.acceptDrag(1);
                    } else {
                        dropTargetDragEvent.rejectDrag();
                    }
                }

                public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                }

                public void drop(DropTargetDropEvent dropTargetDropEvent) {
                    try {
                        Transferable transferable = dropTargetDropEvent.getTransferable();
                        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                            dropTargetDropEvent.acceptDrop(1);
                            List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                            if (list.size() > 0) {
                                File file = (File)list.get(0);
                                if (fileDropListener != null) {
                                    fileDropListener.fileDropped(file);
                                } else if (component instanceof JTextField) {
                                    ((JTextField)component).setText(file.getPath());
                                }
                            }
                            dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                        } else {
                            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
                            boolean bl = false;
                            for (int i = 0; i < dataFlavorArray.length; ++i) {
                                if (!dataFlavorArray[i].isRepresentationClassReader()) continue;
                                dropTargetDropEvent.acceptDrop(1);
                                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                                bl = true;
                                break;
                            }
                            if (!bl) {
                                dropTargetDropEvent.rejectDrop();
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        dropTargetDropEvent.rejectDrop();
                    }
                }

                public void dragExit(DropTargetEvent dropTargetEvent) {
                }

                public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
                    if (FileDrop.this.isDragOk(dropTargetDragEvent)) {
                        dropTargetDragEvent.acceptDrag(1);
                    } else {
                        dropTargetDragEvent.rejectDrag();
                    }
                }
            };
            this.makeDropTarget(component);
        }
    }

    private void makeDropTarget(final Component component) {
        DropTarget dropTarget = new DropTarget();
        try {
            dropTarget.addDropTargetListener(this.dropListener);
        }
        catch (TooManyListenersException tooManyListenersException) {
            tooManyListenersException.printStackTrace();
        }
        component.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                Container container = component.getParent();
                if (container == null) {
                    component.setDropTarget(null);
                } else {
                    new DropTarget(component, FileDrop.this.dropListener);
                }
            }
        });
        if (component.getParent() != null) {
            new DropTarget(component, this.dropListener);
        }
    }

    private boolean isDragOk(DropTargetDragEvent dropTargetDragEvent) {
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            DataFlavor dataFlavor = dataFlavorArray[i];
            if (!dataFlavor.equals(DataFlavor.javaFileListFlavor) && !dataFlavor.isRepresentationClassReader()) continue;
            return true;
        }
        return false;
    }

    static {
        boolean bl;
        try {
            Class.forName("java.awt.dnd.DnDConstants");
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        SUPPORTS_DND = bl;
    }
}

