/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform;

import com.install4j.api.JVMSelector;
import com.install4j.api.Util;
import com.install4j.runtime.installer.platform.macos.MacosJVMLocator;
import com.install4j.runtime.installer.platform.unix.UnixJVMLocator;
import com.install4j.runtime.installer.platform.win32.WinJVMLocator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;

public class JVMLocator {
    public static JVMLocation[] getJVMLocations(File[] fileArray) {
        Collection collection = Util.isWindows() ? WinJVMLocator.getJVMLocations() : (Util.isMacOS() ? MacosJVMLocator.getJVMLocations() : UnixJVMLocator.getJVMLocations());
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                JVMLocation jVMLocation = JVMLocator.getJVMLocation(fileArray[i]);
                if (jVMLocation == null) continue;
                collection.add(jVMLocation);
            }
        }
        return collection.toArray(new JVMLocation[collection.size()]);
    }

    public static JVMLocation getJVMLocation(File file) {
        String[] stringArray;
        String string;
        if (Util.isWindows()) {
            string = "bin/java.exe";
            stringArray = WinJVMLocator.JDK_FILES;
        } else if (Util.isMacOS()) {
            string = "Commands/java";
            stringArray = MacosJVMLocator.JDK_FILES;
        } else {
            string = "bin/java";
            stringArray = UnixJVMLocator.JDK_FILES;
        }
        try {
            return JVMLocator.checkJVMLocation(file, string, stringArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        JVMLocation[] jVMLocationArray = JVMLocator.getJVMLocations(null);
        for (int i = 0; i < jVMLocationArray.length; ++i) {
            JVMLocation jVMLocation = jVMLocationArray[i];
            System.out.println(jVMLocation);
        }
    }

    public static JVMLocation checkJVMLocation(File file, String string, String[] stringArray) throws IOException {
        String string2;
        File file2;
        if (file != null && (file2 = new File(file, string)).exists() && (string2 = JVMLocator.getVersionOutput(file2)) != null && string2.startsWith("java version \"") && string2.endsWith("\"")) {
            JVMLocation jVMLocation = new JVMLocation();
            jVMLocation.setJavaHome(file);
            jVMLocation.setVersion(string2.substring(14, string2.length() - 1));
            jVMLocation.setJDK(JVMLocator.isJDK(file, stringArray));
            return jVMLocation;
        }
        return null;
    }

    private static boolean isJDK(File file, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (new File(file, stringArray[i]).exists()) continue;
            return false;
        }
        return true;
    }

    private static String getVersionOutput(File file) throws IOException {
        String string = null;
        Process process = Runtime.getRuntime().exec(new String[]{file.getAbsolutePath(), "-version"});
        try {
            Thread.interrupted();
            TimeoutThread timeoutThread = new TimeoutThread(Thread.currentThread());
            timeoutThread.start();
            int n = process.waitFor();
            if (n == 0) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                string = bufferedReader.readLine();
                bufferedReader.close();
            }
            timeoutThread.interrupt();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return string;
    }

    public static class JVMLocation
    implements JVMSelector.JVMLocation {
        private File javaHome;
        private String version;
        private boolean jdk = false;

        public void setJavaHome(File file) {
            this.javaHome = file;
        }

        public void setVersion(String string) {
            this.version = string;
        }

        public void setJDK(boolean bl) {
            this.jdk = bl;
        }

        public File getJavaHome() {
            return this.javaHome;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isJDK() {
            return this.jdk;
        }

        public String toString() {
            return this.javaHome + ", version: " + this.version + " (" + (this.jdk ? "JDK" : "JRE") + ")";
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof JVMLocation)) {
                return false;
            }
            JVMLocation jVMLocation = (JVMLocation)object;
            return !(this.javaHome != null ? !this.javaHome.equals(jVMLocation.javaHome) : jVMLocation.javaHome != null);
        }

        public int hashCode() {
            return this.javaHome != null ? this.javaHome.hashCode() : 0;
        }
    }

    private static class TimeoutThread
    extends Thread {
        private Thread watchedThread;

        public TimeoutThread(Thread thread) {
            super("timeout");
            this.setDaemon(true);
            this.watchedThread = thread;
        }

        public void run() {
            try {
                TimeoutThread.sleep(8000L);
                this.watchedThread.interrupt();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

