/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos;

import com.install4j.runtime.installer.platform.JVMLocator;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;

public class MacosJVMLocator {
    private static final String ROOT_LOCATION = "/System/Library/Frameworks/JavaVM.framework/Versions";
    public static final String[] JDK_FILES = new String[]{"Commands/javac", "Home/src.jar"};
    public static final String JAVA_EXECUTABLE = "Commands/java";

    public static Collection getJVMLocations() {
        HashSet<JVMLocator.JVMLocation> hashSet = new HashSet<JVMLocator.JVMLocation>();
        File[] fileArray = new File(ROOT_LOCATION).listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                if (!file.isDirectory()) continue;
                try {
                    JVMLocator.JVMLocation jVMLocation = JVMLocator.checkJVMLocation(file, JAVA_EXECUTABLE, JDK_FILES);
                    if (jVMLocation == null) continue;
                    hashSet.add(jVMLocation);
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return hashSet;
    }
}

