/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.unix;

import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.installer.platform.unix.Execution;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;

public class UnixFileSystem {
    private static final String LINK_ARROW = " -> ";

    public static boolean setMode(int n, File file) {
        return UnixFileSystem.setMode(Integer.toOctalString(n & 0x1FF), file, false);
    }

    public static boolean setMode(String string, File file) {
        return UnixFileSystem.setMode(string, file, false);
    }

    public static boolean setMode(String string, File file, boolean bl) {
        if (Boolean.getBoolean("install4j.noDefaultChmod") && string.equals("644")) {
            return true;
        }
        try {
            if (bl) {
                return Execution.executeAndWait(new String[]{"chmod", "-R", string, file.getAbsolutePath()}, null);
            }
            return Execution.executeAndWait(new String[]{"chmod", string, file.getAbsolutePath()}, null);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean setMode(String string, Collection collection) {
        try {
            String[] stringArray = new String[collection.size() + 2];
            stringArray[0] = "chmod";
            stringArray[1] = string;
            int n = 2;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                stringArray[n++] = file.getAbsolutePath();
            }
            return Execution.executeAndWait(stringArray, null);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean createLink(String string, File file) throws IOException {
        file.delete();
        return Execution.executeAndWait(new String[]{"ln", "-s", string, file.getAbsolutePath()}, null);
    }

    public static boolean setOwner(String string, File file) {
        try {
            return Execution.executeAndWait(new String[]{"chown", string, file.getAbsolutePath()}, null);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static FileInformationImpl getFileInformation(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            if (!Execution.executeAndWait(new String[]{"ls", "-lad", file.getAbsolutePath()}, stringBuffer) || stringBuffer.length() == 0) {
                return null;
            }
            FileInformationImpl fileInformationImpl = new FileInformationImpl();
            fileInformationImpl.mode = UnixFileSystem.getMode(stringBuffer);
            fileInformationImpl.ownerInfo = UnixFileSystem.getOwnerInfo(stringBuffer);
            fileInformationImpl.link = stringBuffer.charAt(0) == 'l';
            if (fileInformationImpl.link) {
                fileInformationImpl.linkTarget = UnixFileSystem.getLinkTarget(stringBuffer.toString());
            }
            return fileInformationImpl;
        }
        catch (Exception exception) {
            System.err.println("Could not get file information for " + file.getAbsolutePath() + ", exception: " + exception.getMessage());
            return null;
        }
    }

    public static int getMode(File file) {
        FileInformationImpl fileInformationImpl = UnixFileSystem.getFileInformation(file);
        if (fileInformationImpl != null) {
            return fileInformationImpl.getMode();
        }
        return -1;
    }

    public static String getOwnerInfo(File file) {
        FileInformationImpl fileInformationImpl = UnixFileSystem.getFileInformation(file);
        if (fileInformationImpl != null) {
            return fileInformationImpl.getOwnerInfo();
        }
        return null;
    }

    private static String getLinkTarget(String string) {
        int n = string.lastIndexOf(LINK_ARROW);
        if (n > -1) {
            return string.substring(n + LINK_ARROW.length()).trim();
        }
        return null;
    }

    private static String getOwnerInfo(StringBuffer stringBuffer) {
        int n;
        String string = "";
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), " ");
        for (n = 0; stringTokenizer.hasMoreTokens() && n < 4; ++n) {
            String string2 = stringTokenizer.nextToken();
            if (n == 2) {
                string = string2.trim();
                continue;
            }
            if (n != 3) continue;
            string = string + ":" + string2.trim();
        }
        if (n == 4 && string.length() > 0) {
            return string;
        }
        return null;
    }

    private static int getMode(StringBuffer stringBuffer) {
        if (stringBuffer.length() < 10) {
            return -1;
        }
        int n = UnixFileSystem.getGroupMode(stringBuffer, 0);
        n += UnixFileSystem.getGroupMode(stringBuffer, 1);
        return n += UnixFileSystem.getGroupMode(stringBuffer, 2);
    }

    private static int getGroupMode(StringBuffer stringBuffer, int n) {
        int n2 = (int)Math.pow(8.0, 2 - n);
        int n3 = 0;
        if (stringBuffer.charAt(1 + n * 3) == 'r') {
            n3 += n2 * 4;
        }
        if (stringBuffer.charAt(2 + n * 3) == 'w') {
            n3 += n2 * 2;
        }
        if (stringBuffer.charAt(3 + n * 3) == 'x') {
            n3 += n2;
        }
        return n3;
    }

    public static class FileInformationImpl
    implements UnixFileSystem.FileInformation {
        private int mode = -1;
        private String ownerInfo;
        private boolean link;
        private String linkTarget;

        private FileInformationImpl() {
        }

        public int getMode() {
            return this.mode;
        }

        public String getOwnerInfo() {
            return this.ownerInfo;
        }

        public boolean isLink() {
            return this.link;
        }

        public String getLinkTarget() {
            return this.linkTarget;
        }

        public String toString() {
            return Integer.toOctalString(this.mode) + ", " + this.ownerInfo + ", link: " + this.link + (this.link ? ", target: " + this.linkTarget : "");
        }
    }
}

