/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.win32;

import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.platform.JVMLocator;
import com.install4j.runtime.installer.platform.win32.FolderInfo;
import com.install4j.runtime.installer.platform.win32.Registry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class WinJVMLocator {
    private static final String REGKEY_JAVASOFT_JDK = "SOFTWARE\\JavaSoft\\Java Development Kit";
    private static final String REGKEY_JAVASOFT_JRE = "SOFTWARE\\JavaSoft\\Java Runtime Environment";
    private static final String REGVAL_JAVAHOME = "JavaHome";
    public static final String[] JDK_FILES = new String[]{"bin/javac.exe", "lib/tools.jar"};
    public static final String JAVA_EXECUTABLE = "bin/java.exe";

    public static Collection getJVMLocations() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(WinJVMLocator.getFromKey(REGKEY_JAVASOFT_JDK));
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ((JVMLocator.JVMLocation)iterator.next()).setJDK(true);
        }
        hashSet.addAll(WinJVMLocator.getFromKey(REGKEY_JAVASOFT_JRE));
        hashSet.addAll(WinJVMLocator.getSharedJRES());
        return hashSet;
    }

    private static Collection getSharedJRES() {
        ArrayList<JVMLocator.JVMLocation> arrayList = new ArrayList<JVMLocator.JVMLocation>();
        File file = InstallerUtil.isWindows9X() ? FolderInfo.getProgramFilesDirectory() : FolderInfo.getCommonFilesDirectory();
        File[] fileArray = (file = new File(file, "i4j_jres")).listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.isDirectory() || file2.getName().startsWith("jre") || !new File(file2, "bin\\java.exe").exists()) continue;
                JVMLocator.JVMLocation jVMLocation = new JVMLocator.JVMLocation();
                jVMLocation.setJavaHome(file2);
                jVMLocation.setVersion(file2.getName());
                arrayList.add(jVMLocation);
            }
        }
        return arrayList;
    }

    private static Collection getFromKey(String string) {
        HashMap<JVMLocator.JVMLocation, JVMLocator.JVMLocation> hashMap = new HashMap<JVMLocator.JVMLocation, JVMLocator.JVMLocation>();
        String[] stringArray = Registry.enumSubKeys(3, string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                String string3 = stringArray[i];
                JVMLocator.JVMLocation jVMLocation = new JVMLocator.JVMLocation();
                jVMLocation.setVersion(string3);
                Object object = Registry.getValue(3, string + "\\" + string3, REGVAL_JAVAHOME);
                if (object == null || !(object instanceof String) || !new File((string2 = (String)object) + "\\bin\\java.exe").exists()) continue;
                jVMLocation.setJavaHome(new File(string2));
                JVMLocator.JVMLocation jVMLocation2 = (JVMLocator.JVMLocation)hashMap.get(jVMLocation);
                if (jVMLocation2 != null && jVMLocation2.getVersion().length() >= jVMLocation.getVersion().length()) continue;
                hashMap.put(jVMLocation, jVMLocation);
            }
        }
        return hashMap.values();
    }
}

