/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.wizard;

import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.wizard.CustomFrame;
import com.install4j.runtime.wizard.WizardBase;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class WizardFrame
extends CustomFrame {
    private WizardBase wizardBase;

    public WizardFrame(WizardBase wizardBase, JFrame jFrame) {
        this.wizardBase = wizardBase;
        this.init(jFrame);
    }

    protected int getFrameHeight() {
        return this.wizardBase.getFrameHeight();
    }

    protected int getFrameWidth() {
        return this.wizardBase.getFrameWidth();
    }

    private void init(JFrame jFrame) {
        this.setContentPane(this.wizardBase);
        if (this.isMacOS()) {
            this.wizardBase.setBorder(BorderFactory.createEmptyBorder(0, 0, 11, 0));
        }
        if (jFrame != null) {
            this.setIconImage(jFrame.getIconImage());
        }
        this.setTitle(this.wizardBase.getTitle());
        this.setBounds(this.getNewFrameBounds());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (WizardFrame.this.wizardBase.isQuitOnWindowClose()) {
                    WizardFrame.this.wizardBase.cancel();
                } else if (WizardFrame.this.wizardBase.isFinishOnWindowClose()) {
                    WizardFrame.this.wizardBase.finishFromCloseButton();
                }
            }

            public void windowOpened(WindowEvent windowEvent) {
                if (InstallerUtil.isUpToJava15()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            int n = WizardFrame.this.getWidth();
                            int n2 = WizardFrame.this.getHeight();
                            WizardFrame.this.setSize(n + 1, n2);
                            WizardFrame.this.validate();
                            WizardFrame.this.setSize(n, n2);
                            WizardFrame.this.validate();
                        }
                    });
                }
                Toolkit.getDefaultToolkit().sync();
            }
        });
    }

    private boolean isMacOS() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac");
    }
}

